/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.GatewayNetwork;
import com.amazonaws.services.mediaconnect.model.GatewayState;
import com.amazonaws.services.mediaconnect.model.MessageDetail;
import com.amazonaws.services.mediaconnect.model.transform.GatewayMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Gateway
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> egressCidrBlocks;
    private String gatewayArn;
    private List<MessageDetail> gatewayMessages;
    private String gatewayState;
    private String name;
    private List<GatewayNetwork> networks;

    public List<String> getEgressCidrBlocks() {
        return this.egressCidrBlocks;
    }

    public void setEgressCidrBlocks(Collection<String> egressCidrBlocks) {
        if (egressCidrBlocks == null) {
            this.egressCidrBlocks = null;
            return;
        }
        this.egressCidrBlocks = new ArrayList<String>(egressCidrBlocks);
    }

    public Gateway withEgressCidrBlocks(String ... egressCidrBlocks) {
        if (this.egressCidrBlocks == null) {
            this.setEgressCidrBlocks(new ArrayList<String>(egressCidrBlocks.length));
        }
        for (String ele : egressCidrBlocks) {
            this.egressCidrBlocks.add(ele);
        }
        return this;
    }

    public Gateway withEgressCidrBlocks(Collection<String> egressCidrBlocks) {
        this.setEgressCidrBlocks(egressCidrBlocks);
        return this;
    }

    public void setGatewayArn(String gatewayArn) {
        this.gatewayArn = gatewayArn;
    }

    public String getGatewayArn() {
        return this.gatewayArn;
    }

    public Gateway withGatewayArn(String gatewayArn) {
        this.setGatewayArn(gatewayArn);
        return this;
    }

    public List<MessageDetail> getGatewayMessages() {
        return this.gatewayMessages;
    }

    public void setGatewayMessages(Collection<MessageDetail> gatewayMessages) {
        if (gatewayMessages == null) {
            this.gatewayMessages = null;
            return;
        }
        this.gatewayMessages = new ArrayList<MessageDetail>(gatewayMessages);
    }

    public Gateway withGatewayMessages(MessageDetail ... gatewayMessages) {
        if (this.gatewayMessages == null) {
            this.setGatewayMessages(new ArrayList<MessageDetail>(gatewayMessages.length));
        }
        for (MessageDetail ele : gatewayMessages) {
            this.gatewayMessages.add(ele);
        }
        return this;
    }

    public Gateway withGatewayMessages(Collection<MessageDetail> gatewayMessages) {
        this.setGatewayMessages(gatewayMessages);
        return this;
    }

    public void setGatewayState(String gatewayState) {
        this.gatewayState = gatewayState;
    }

    public String getGatewayState() {
        return this.gatewayState;
    }

    public Gateway withGatewayState(String gatewayState) {
        this.setGatewayState(gatewayState);
        return this;
    }

    public Gateway withGatewayState(GatewayState gatewayState) {
        this.gatewayState = gatewayState.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Gateway withName(String name) {
        this.setName(name);
        return this;
    }

    public List<GatewayNetwork> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Collection<GatewayNetwork> networks) {
        if (networks == null) {
            this.networks = null;
            return;
        }
        this.networks = new ArrayList<GatewayNetwork>(networks);
    }

    public Gateway withNetworks(GatewayNetwork ... networks) {
        if (this.networks == null) {
            this.setNetworks(new ArrayList<GatewayNetwork>(networks.length));
        }
        for (GatewayNetwork ele : networks) {
            this.networks.add(ele);
        }
        return this;
    }

    public Gateway withNetworks(Collection<GatewayNetwork> networks) {
        this.setNetworks(networks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEgressCidrBlocks() != null) {
            sb.append("EgressCidrBlocks: ").append(this.getEgressCidrBlocks()).append(",");
        }
        if (this.getGatewayArn() != null) {
            sb.append("GatewayArn: ").append(this.getGatewayArn()).append(",");
        }
        if (this.getGatewayMessages() != null) {
            sb.append("GatewayMessages: ").append(this.getGatewayMessages()).append(",");
        }
        if (this.getGatewayState() != null) {
            sb.append("GatewayState: ").append(this.getGatewayState()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getNetworks() != null) {
            sb.append("Networks: ").append(this.getNetworks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gateway)) {
            return false;
        }
        Gateway other = (Gateway)obj;
        if (other.getEgressCidrBlocks() == null ^ this.getEgressCidrBlocks() == null) {
            return false;
        }
        if (other.getEgressCidrBlocks() != null && !other.getEgressCidrBlocks().equals(this.getEgressCidrBlocks())) {
            return false;
        }
        if (other.getGatewayArn() == null ^ this.getGatewayArn() == null) {
            return false;
        }
        if (other.getGatewayArn() != null && !other.getGatewayArn().equals(this.getGatewayArn())) {
            return false;
        }
        if (other.getGatewayMessages() == null ^ this.getGatewayMessages() == null) {
            return false;
        }
        if (other.getGatewayMessages() != null && !other.getGatewayMessages().equals(this.getGatewayMessages())) {
            return false;
        }
        if (other.getGatewayState() == null ^ this.getGatewayState() == null) {
            return false;
        }
        if (other.getGatewayState() != null && !other.getGatewayState().equals(this.getGatewayState())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNetworks() == null ^ this.getNetworks() == null) {
            return false;
        }
        return other.getNetworks() == null || other.getNetworks().equals(this.getNetworks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEgressCidrBlocks() == null ? 0 : this.getEgressCidrBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayArn() == null ? 0 : this.getGatewayArn().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayMessages() == null ? 0 : this.getGatewayMessages().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayState() == null ? 0 : this.getGatewayState().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNetworks() == null ? 0 : this.getNetworks().hashCode());
        return hashCode;
    }

    public Gateway clone() {
        try {
            return (Gateway)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GatewayMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

