/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.BridgeOutput;
import com.amazonaws.services.mediaconnect.model.BridgeSource;
import com.amazonaws.services.mediaconnect.model.BridgeState;
import com.amazonaws.services.mediaconnect.model.EgressGatewayBridge;
import com.amazonaws.services.mediaconnect.model.FailoverConfig;
import com.amazonaws.services.mediaconnect.model.IngressGatewayBridge;
import com.amazonaws.services.mediaconnect.model.MessageDetail;
import com.amazonaws.services.mediaconnect.model.transform.BridgeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Bridge
implements Serializable,
Cloneable,
StructuredPojo {
    private String bridgeArn;
    private List<MessageDetail> bridgeMessages;
    private String bridgeState;
    private EgressGatewayBridge egressGatewayBridge;
    private IngressGatewayBridge ingressGatewayBridge;
    private String name;
    private List<BridgeOutput> outputs;
    private String placementArn;
    private FailoverConfig sourceFailoverConfig;
    private List<BridgeSource> sources;

    public void setBridgeArn(String bridgeArn) {
        this.bridgeArn = bridgeArn;
    }

    public String getBridgeArn() {
        return this.bridgeArn;
    }

    public Bridge withBridgeArn(String bridgeArn) {
        this.setBridgeArn(bridgeArn);
        return this;
    }

    public List<MessageDetail> getBridgeMessages() {
        return this.bridgeMessages;
    }

    public void setBridgeMessages(Collection<MessageDetail> bridgeMessages) {
        if (bridgeMessages == null) {
            this.bridgeMessages = null;
            return;
        }
        this.bridgeMessages = new ArrayList<MessageDetail>(bridgeMessages);
    }

    public Bridge withBridgeMessages(MessageDetail ... bridgeMessages) {
        if (this.bridgeMessages == null) {
            this.setBridgeMessages(new ArrayList<MessageDetail>(bridgeMessages.length));
        }
        for (MessageDetail ele : bridgeMessages) {
            this.bridgeMessages.add(ele);
        }
        return this;
    }

    public Bridge withBridgeMessages(Collection<MessageDetail> bridgeMessages) {
        this.setBridgeMessages(bridgeMessages);
        return this;
    }

    public void setBridgeState(String bridgeState) {
        this.bridgeState = bridgeState;
    }

    public String getBridgeState() {
        return this.bridgeState;
    }

    public Bridge withBridgeState(String bridgeState) {
        this.setBridgeState(bridgeState);
        return this;
    }

    public Bridge withBridgeState(BridgeState bridgeState) {
        this.bridgeState = bridgeState.toString();
        return this;
    }

    public void setEgressGatewayBridge(EgressGatewayBridge egressGatewayBridge) {
        this.egressGatewayBridge = egressGatewayBridge;
    }

    public EgressGatewayBridge getEgressGatewayBridge() {
        return this.egressGatewayBridge;
    }

    public Bridge withEgressGatewayBridge(EgressGatewayBridge egressGatewayBridge) {
        this.setEgressGatewayBridge(egressGatewayBridge);
        return this;
    }

    public void setIngressGatewayBridge(IngressGatewayBridge ingressGatewayBridge) {
        this.ingressGatewayBridge = ingressGatewayBridge;
    }

    public IngressGatewayBridge getIngressGatewayBridge() {
        return this.ingressGatewayBridge;
    }

    public Bridge withIngressGatewayBridge(IngressGatewayBridge ingressGatewayBridge) {
        this.setIngressGatewayBridge(ingressGatewayBridge);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Bridge withName(String name) {
        this.setName(name);
        return this;
    }

    public List<BridgeOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<BridgeOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<BridgeOutput>(outputs);
    }

    public Bridge withOutputs(BridgeOutput ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<BridgeOutput>(outputs.length));
        }
        for (BridgeOutput ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public Bridge withOutputs(Collection<BridgeOutput> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setPlacementArn(String placementArn) {
        this.placementArn = placementArn;
    }

    public String getPlacementArn() {
        return this.placementArn;
    }

    public Bridge withPlacementArn(String placementArn) {
        this.setPlacementArn(placementArn);
        return this;
    }

    public void setSourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
        this.sourceFailoverConfig = sourceFailoverConfig;
    }

    public FailoverConfig getSourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    public Bridge withSourceFailoverConfig(FailoverConfig sourceFailoverConfig) {
        this.setSourceFailoverConfig(sourceFailoverConfig);
        return this;
    }

    public List<BridgeSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<BridgeSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<BridgeSource>(sources);
    }

    public Bridge withSources(BridgeSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<BridgeSource>(sources.length));
        }
        for (BridgeSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public Bridge withSources(Collection<BridgeSource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBridgeArn() != null) {
            sb.append("BridgeArn: ").append(this.getBridgeArn()).append(",");
        }
        if (this.getBridgeMessages() != null) {
            sb.append("BridgeMessages: ").append(this.getBridgeMessages()).append(",");
        }
        if (this.getBridgeState() != null) {
            sb.append("BridgeState: ").append(this.getBridgeState()).append(",");
        }
        if (this.getEgressGatewayBridge() != null) {
            sb.append("EgressGatewayBridge: ").append(this.getEgressGatewayBridge()).append(",");
        }
        if (this.getIngressGatewayBridge() != null) {
            sb.append("IngressGatewayBridge: ").append(this.getIngressGatewayBridge()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getPlacementArn() != null) {
            sb.append("PlacementArn: ").append(this.getPlacementArn()).append(",");
        }
        if (this.getSourceFailoverConfig() != null) {
            sb.append("SourceFailoverConfig: ").append(this.getSourceFailoverConfig()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bridge)) {
            return false;
        }
        Bridge other = (Bridge)obj;
        if (other.getBridgeArn() == null ^ this.getBridgeArn() == null) {
            return false;
        }
        if (other.getBridgeArn() != null && !other.getBridgeArn().equals(this.getBridgeArn())) {
            return false;
        }
        if (other.getBridgeMessages() == null ^ this.getBridgeMessages() == null) {
            return false;
        }
        if (other.getBridgeMessages() != null && !other.getBridgeMessages().equals(this.getBridgeMessages())) {
            return false;
        }
        if (other.getBridgeState() == null ^ this.getBridgeState() == null) {
            return false;
        }
        if (other.getBridgeState() != null && !other.getBridgeState().equals(this.getBridgeState())) {
            return false;
        }
        if (other.getEgressGatewayBridge() == null ^ this.getEgressGatewayBridge() == null) {
            return false;
        }
        if (other.getEgressGatewayBridge() != null && !other.getEgressGatewayBridge().equals(this.getEgressGatewayBridge())) {
            return false;
        }
        if (other.getIngressGatewayBridge() == null ^ this.getIngressGatewayBridge() == null) {
            return false;
        }
        if (other.getIngressGatewayBridge() != null && !other.getIngressGatewayBridge().equals(this.getIngressGatewayBridge())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getPlacementArn() == null ^ this.getPlacementArn() == null) {
            return false;
        }
        if (other.getPlacementArn() != null && !other.getPlacementArn().equals(this.getPlacementArn())) {
            return false;
        }
        if (other.getSourceFailoverConfig() == null ^ this.getSourceFailoverConfig() == null) {
            return false;
        }
        if (other.getSourceFailoverConfig() != null && !other.getSourceFailoverConfig().equals(this.getSourceFailoverConfig())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBridgeArn() == null ? 0 : this.getBridgeArn().hashCode());
        hashCode = 31 * hashCode + (this.getBridgeMessages() == null ? 0 : this.getBridgeMessages().hashCode());
        hashCode = 31 * hashCode + (this.getBridgeState() == null ? 0 : this.getBridgeState().hashCode());
        hashCode = 31 * hashCode + (this.getEgressGatewayBridge() == null ? 0 : this.getEgressGatewayBridge().hashCode());
        hashCode = 31 * hashCode + (this.getIngressGatewayBridge() == null ? 0 : this.getIngressGatewayBridge().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementArn() == null ? 0 : this.getPlacementArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceFailoverConfig() == null ? 0 : this.getSourceFailoverConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public Bridge clone() {
        try {
            return (Bridge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BridgeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

