/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mturk.AmazonMTurk;
import com.amazonaws.services.mturk.AmazonMTurkClientBuilder;
import com.amazonaws.services.mturk.model.AcceptQualificationRequestRequest;
import com.amazonaws.services.mturk.model.AcceptQualificationRequestResult;
import com.amazonaws.services.mturk.model.AmazonMTurkException;
import com.amazonaws.services.mturk.model.ApproveAssignmentRequest;
import com.amazonaws.services.mturk.model.ApproveAssignmentResult;
import com.amazonaws.services.mturk.model.AssociateQualificationWithWorkerRequest;
import com.amazonaws.services.mturk.model.AssociateQualificationWithWorkerResult;
import com.amazonaws.services.mturk.model.CreateAdditionalAssignmentsForHITRequest;
import com.amazonaws.services.mturk.model.CreateAdditionalAssignmentsForHITResult;
import com.amazonaws.services.mturk.model.CreateHITRequest;
import com.amazonaws.services.mturk.model.CreateHITResult;
import com.amazonaws.services.mturk.model.CreateHITTypeRequest;
import com.amazonaws.services.mturk.model.CreateHITTypeResult;
import com.amazonaws.services.mturk.model.CreateHITWithHITTypeRequest;
import com.amazonaws.services.mturk.model.CreateHITWithHITTypeResult;
import com.amazonaws.services.mturk.model.CreateQualificationTypeRequest;
import com.amazonaws.services.mturk.model.CreateQualificationTypeResult;
import com.amazonaws.services.mturk.model.CreateWorkerBlockRequest;
import com.amazonaws.services.mturk.model.CreateWorkerBlockResult;
import com.amazonaws.services.mturk.model.DeleteHITRequest;
import com.amazonaws.services.mturk.model.DeleteHITResult;
import com.amazonaws.services.mturk.model.DeleteQualificationTypeRequest;
import com.amazonaws.services.mturk.model.DeleteQualificationTypeResult;
import com.amazonaws.services.mturk.model.DeleteWorkerBlockRequest;
import com.amazonaws.services.mturk.model.DeleteWorkerBlockResult;
import com.amazonaws.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import com.amazonaws.services.mturk.model.DisassociateQualificationFromWorkerResult;
import com.amazonaws.services.mturk.model.GetAccountBalanceRequest;
import com.amazonaws.services.mturk.model.GetAccountBalanceResult;
import com.amazonaws.services.mturk.model.GetAssignmentRequest;
import com.amazonaws.services.mturk.model.GetAssignmentResult;
import com.amazonaws.services.mturk.model.GetFileUploadURLRequest;
import com.amazonaws.services.mturk.model.GetFileUploadURLResult;
import com.amazonaws.services.mturk.model.GetHITRequest;
import com.amazonaws.services.mturk.model.GetHITResult;
import com.amazonaws.services.mturk.model.GetQualificationScoreRequest;
import com.amazonaws.services.mturk.model.GetQualificationScoreResult;
import com.amazonaws.services.mturk.model.GetQualificationTypeRequest;
import com.amazonaws.services.mturk.model.GetQualificationTypeResult;
import com.amazonaws.services.mturk.model.ListAssignmentsForHITRequest;
import com.amazonaws.services.mturk.model.ListAssignmentsForHITResult;
import com.amazonaws.services.mturk.model.ListBonusPaymentsRequest;
import com.amazonaws.services.mturk.model.ListBonusPaymentsResult;
import com.amazonaws.services.mturk.model.ListHITsForQualificationTypeRequest;
import com.amazonaws.services.mturk.model.ListHITsForQualificationTypeResult;
import com.amazonaws.services.mturk.model.ListHITsRequest;
import com.amazonaws.services.mturk.model.ListHITsResult;
import com.amazonaws.services.mturk.model.ListQualificationRequestsRequest;
import com.amazonaws.services.mturk.model.ListQualificationRequestsResult;
import com.amazonaws.services.mturk.model.ListQualificationTypesRequest;
import com.amazonaws.services.mturk.model.ListQualificationTypesResult;
import com.amazonaws.services.mturk.model.ListReviewPolicyResultsForHITRequest;
import com.amazonaws.services.mturk.model.ListReviewPolicyResultsForHITResult;
import com.amazonaws.services.mturk.model.ListReviewableHITsRequest;
import com.amazonaws.services.mturk.model.ListReviewableHITsResult;
import com.amazonaws.services.mturk.model.ListWorkerBlocksRequest;
import com.amazonaws.services.mturk.model.ListWorkerBlocksResult;
import com.amazonaws.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import com.amazonaws.services.mturk.model.ListWorkersWithQualificationTypeResult;
import com.amazonaws.services.mturk.model.NotifyWorkersRequest;
import com.amazonaws.services.mturk.model.NotifyWorkersResult;
import com.amazonaws.services.mturk.model.RejectAssignmentRequest;
import com.amazonaws.services.mturk.model.RejectAssignmentResult;
import com.amazonaws.services.mturk.model.RejectQualificationRequestRequest;
import com.amazonaws.services.mturk.model.RejectQualificationRequestResult;
import com.amazonaws.services.mturk.model.RequestErrorException;
import com.amazonaws.services.mturk.model.SendBonusRequest;
import com.amazonaws.services.mturk.model.SendBonusResult;
import com.amazonaws.services.mturk.model.SendTestEventNotificationRequest;
import com.amazonaws.services.mturk.model.SendTestEventNotificationResult;
import com.amazonaws.services.mturk.model.ServiceException;
import com.amazonaws.services.mturk.model.UpdateExpirationForHITRequest;
import com.amazonaws.services.mturk.model.UpdateExpirationForHITResult;
import com.amazonaws.services.mturk.model.UpdateHITReviewStatusRequest;
import com.amazonaws.services.mturk.model.UpdateHITReviewStatusResult;
import com.amazonaws.services.mturk.model.UpdateHITTypeOfHITRequest;
import com.amazonaws.services.mturk.model.UpdateHITTypeOfHITResult;
import com.amazonaws.services.mturk.model.UpdateNotificationSettingsRequest;
import com.amazonaws.services.mturk.model.UpdateNotificationSettingsResult;
import com.amazonaws.services.mturk.model.UpdateQualificationTypeRequest;
import com.amazonaws.services.mturk.model.UpdateQualificationTypeResult;
import com.amazonaws.services.mturk.model.transform.AcceptQualificationRequestRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.AcceptQualificationRequestResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ApproveAssignmentRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ApproveAssignmentResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.AssociateQualificationWithWorkerRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.AssociateQualificationWithWorkerResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.CreateAdditionalAssignmentsForHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.CreateAdditionalAssignmentsForHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.CreateHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.CreateHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.CreateHITTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.CreateHITTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.CreateHITWithHITTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.CreateHITWithHITTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.CreateQualificationTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.CreateQualificationTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.CreateWorkerBlockRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.CreateWorkerBlockResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.DeleteHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.DeleteHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.DeleteQualificationTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.DeleteQualificationTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.DeleteWorkerBlockRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.DeleteWorkerBlockResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.DisassociateQualificationFromWorkerRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.DisassociateQualificationFromWorkerResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.GetAccountBalanceRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.GetAccountBalanceResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.GetAssignmentRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.GetAssignmentResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.GetFileUploadURLRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.GetFileUploadURLResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.GetHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.GetHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.GetQualificationScoreRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.GetQualificationScoreResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.GetQualificationTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.GetQualificationTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListAssignmentsForHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListAssignmentsForHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListBonusPaymentsRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListBonusPaymentsResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListHITsForQualificationTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListHITsForQualificationTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListHITsRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListHITsResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListQualificationRequestsRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListQualificationRequestsResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListQualificationTypesRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListQualificationTypesResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListReviewPolicyResultsForHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListReviewPolicyResultsForHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListReviewableHITsRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListReviewableHITsResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListWorkerBlocksRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListWorkerBlocksResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.ListWorkersWithQualificationTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.ListWorkersWithQualificationTypeResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.NotifyWorkersRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.NotifyWorkersResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.RejectAssignmentRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.RejectAssignmentResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.RejectQualificationRequestRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.RejectQualificationRequestResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.SendBonusRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.SendBonusResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.SendTestEventNotificationRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.SendTestEventNotificationResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateExpirationForHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateExpirationForHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateHITReviewStatusRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateHITReviewStatusResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateHITTypeOfHITRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateHITTypeOfHITResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateNotificationSettingsRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateNotificationSettingsResultJsonUnmarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateQualificationTypeRequestProtocolMarshaller;
import com.amazonaws.services.mturk.model.transform.UpdateQualificationTypeResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonMTurkClient
extends AmazonWebServiceClient
implements AmazonMTurk {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonMTurk.class);
    private static final String DEFAULT_SIGNING_NAME = "mturk-requester";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFault").withModeledClass(ServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestError").withModeledClass(RequestErrorException.class)).withBaseServiceExceptionClass(AmazonMTurkException.class));

    public static AmazonMTurkClientBuilder builder() {
        return AmazonMTurkClientBuilder.standard();
    }

    AmazonMTurkClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mturk-requester.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mturk/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mturk/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcceptQualificationRequestResult acceptQualificationRequest(AcceptQualificationRequestRequest request) {
        request = (AcceptQualificationRequestRequest)this.beforeClientExecution(request);
        return this.executeAcceptQualificationRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcceptQualificationRequestResult executeAcceptQualificationRequest(AcceptQualificationRequestRequest acceptQualificationRequestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acceptQualificationRequestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcceptQualificationRequestRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcceptQualificationRequestRequestProtocolMarshaller(protocolFactory).marshall((AcceptQualificationRequestRequest)super.beforeMarshalling((AmazonWebServiceRequest)acceptQualificationRequestRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AcceptQualificationRequest");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptQualificationRequestResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcceptQualificationRequestResult acceptQualificationRequestResult = (AcceptQualificationRequestResult)response.getAwsResponse();
            return acceptQualificationRequestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ApproveAssignmentResult approveAssignment(ApproveAssignmentRequest request) {
        request = (ApproveAssignmentRequest)this.beforeClientExecution(request);
        return this.executeApproveAssignment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ApproveAssignmentResult executeApproveAssignment(ApproveAssignmentRequest approveAssignmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(approveAssignmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ApproveAssignmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ApproveAssignmentRequestProtocolMarshaller(protocolFactory).marshall((ApproveAssignmentRequest)super.beforeMarshalling((AmazonWebServiceRequest)approveAssignmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ApproveAssignment");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ApproveAssignmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ApproveAssignmentResult approveAssignmentResult = (ApproveAssignmentResult)response.getAwsResponse();
            return approveAssignmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateQualificationWithWorkerResult associateQualificationWithWorker(AssociateQualificationWithWorkerRequest request) {
        request = (AssociateQualificationWithWorkerRequest)this.beforeClientExecution(request);
        return this.executeAssociateQualificationWithWorker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateQualificationWithWorkerResult executeAssociateQualificationWithWorker(AssociateQualificationWithWorkerRequest associateQualificationWithWorkerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateQualificationWithWorkerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateQualificationWithWorkerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateQualificationWithWorkerRequestProtocolMarshaller(protocolFactory).marshall((AssociateQualificationWithWorkerRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateQualificationWithWorkerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateQualificationWithWorker");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateQualificationWithWorkerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateQualificationWithWorkerResult associateQualificationWithWorkerResult = (AssociateQualificationWithWorkerResult)response.getAwsResponse();
            return associateQualificationWithWorkerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAdditionalAssignmentsForHITResult createAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHITRequest request) {
        request = (CreateAdditionalAssignmentsForHITRequest)this.beforeClientExecution(request);
        return this.executeCreateAdditionalAssignmentsForHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAdditionalAssignmentsForHITResult executeCreateAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHITRequest createAdditionalAssignmentsForHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAdditionalAssignmentsForHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAdditionalAssignmentsForHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAdditionalAssignmentsForHITRequestProtocolMarshaller(protocolFactory).marshall((CreateAdditionalAssignmentsForHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAdditionalAssignmentsForHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAdditionalAssignmentsForHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAdditionalAssignmentsForHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAdditionalAssignmentsForHITResult createAdditionalAssignmentsForHITResult = (CreateAdditionalAssignmentsForHITResult)response.getAwsResponse();
            return createAdditionalAssignmentsForHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateHITResult createHIT(CreateHITRequest request) {
        request = (CreateHITRequest)this.beforeClientExecution(request);
        return this.executeCreateHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHITResult executeCreateHIT(CreateHITRequest createHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHITRequestProtocolMarshaller(protocolFactory).marshall((CreateHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHITResult createHITResult = (CreateHITResult)response.getAwsResponse();
            return createHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateHITTypeResult createHITType(CreateHITTypeRequest request) {
        request = (CreateHITTypeRequest)this.beforeClientExecution(request);
        return this.executeCreateHITType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHITTypeResult executeCreateHITType(CreateHITTypeRequest createHITTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHITTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHITTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHITTypeRequestProtocolMarshaller(protocolFactory).marshall((CreateHITTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHITTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHITType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHITTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHITTypeResult createHITTypeResult = (CreateHITTypeResult)response.getAwsResponse();
            return createHITTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateHITWithHITTypeResult createHITWithHITType(CreateHITWithHITTypeRequest request) {
        request = (CreateHITWithHITTypeRequest)this.beforeClientExecution(request);
        return this.executeCreateHITWithHITType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHITWithHITTypeResult executeCreateHITWithHITType(CreateHITWithHITTypeRequest createHITWithHITTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHITWithHITTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHITWithHITTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHITWithHITTypeRequestProtocolMarshaller(protocolFactory).marshall((CreateHITWithHITTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHITWithHITTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHITWithHITType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHITWithHITTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHITWithHITTypeResult createHITWithHITTypeResult = (CreateHITWithHITTypeResult)response.getAwsResponse();
            return createHITWithHITTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateQualificationTypeResult createQualificationType(CreateQualificationTypeRequest request) {
        request = (CreateQualificationTypeRequest)this.beforeClientExecution(request);
        return this.executeCreateQualificationType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateQualificationTypeResult executeCreateQualificationType(CreateQualificationTypeRequest createQualificationTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createQualificationTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateQualificationTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateQualificationTypeRequestProtocolMarshaller(protocolFactory).marshall((CreateQualificationTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createQualificationTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateQualificationType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateQualificationTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateQualificationTypeResult createQualificationTypeResult = (CreateQualificationTypeResult)response.getAwsResponse();
            return createQualificationTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkerBlockResult createWorkerBlock(CreateWorkerBlockRequest request) {
        request = (CreateWorkerBlockRequest)this.beforeClientExecution(request);
        return this.executeCreateWorkerBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkerBlockResult executeCreateWorkerBlock(CreateWorkerBlockRequest createWorkerBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkerBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkerBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkerBlockRequestProtocolMarshaller(protocolFactory).marshall((CreateWorkerBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWorkerBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateWorkerBlock");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkerBlockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkerBlockResult createWorkerBlockResult = (CreateWorkerBlockResult)response.getAwsResponse();
            return createWorkerBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteHITResult deleteHIT(DeleteHITRequest request) {
        request = (DeleteHITRequest)this.beforeClientExecution(request);
        return this.executeDeleteHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteHITResult executeDeleteHIT(DeleteHITRequest deleteHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHITRequestProtocolMarshaller(protocolFactory).marshall((DeleteHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteHITResult deleteHITResult = (DeleteHITResult)response.getAwsResponse();
            return deleteHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteQualificationTypeResult deleteQualificationType(DeleteQualificationTypeRequest request) {
        request = (DeleteQualificationTypeRequest)this.beforeClientExecution(request);
        return this.executeDeleteQualificationType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteQualificationTypeResult executeDeleteQualificationType(DeleteQualificationTypeRequest deleteQualificationTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteQualificationTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteQualificationTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteQualificationTypeRequestProtocolMarshaller(protocolFactory).marshall((DeleteQualificationTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteQualificationTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteQualificationType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteQualificationTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteQualificationTypeResult deleteQualificationTypeResult = (DeleteQualificationTypeResult)response.getAwsResponse();
            return deleteQualificationTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteWorkerBlockResult deleteWorkerBlock(DeleteWorkerBlockRequest request) {
        request = (DeleteWorkerBlockRequest)this.beforeClientExecution(request);
        return this.executeDeleteWorkerBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteWorkerBlockResult executeDeleteWorkerBlock(DeleteWorkerBlockRequest deleteWorkerBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWorkerBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWorkerBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWorkerBlockRequestProtocolMarshaller(protocolFactory).marshall((DeleteWorkerBlockRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWorkerBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteWorkerBlock");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWorkerBlockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteWorkerBlockResult deleteWorkerBlockResult = (DeleteWorkerBlockResult)response.getAwsResponse();
            return deleteWorkerBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateQualificationFromWorkerResult disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest request) {
        request = (DisassociateQualificationFromWorkerRequest)this.beforeClientExecution(request);
        return this.executeDisassociateQualificationFromWorker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateQualificationFromWorkerResult executeDisassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest disassociateQualificationFromWorkerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateQualificationFromWorkerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateQualificationFromWorkerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateQualificationFromWorkerRequestProtocolMarshaller(protocolFactory).marshall((DisassociateQualificationFromWorkerRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateQualificationFromWorkerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateQualificationFromWorker");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateQualificationFromWorkerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateQualificationFromWorkerResult disassociateQualificationFromWorkerResult = (DisassociateQualificationFromWorkerResult)response.getAwsResponse();
            return disassociateQualificationFromWorkerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccountBalanceResult getAccountBalance(GetAccountBalanceRequest request) {
        request = (GetAccountBalanceRequest)this.beforeClientExecution(request);
        return this.executeGetAccountBalance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccountBalanceResult executeGetAccountBalance(GetAccountBalanceRequest getAccountBalanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccountBalanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccountBalanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccountBalanceRequestProtocolMarshaller(protocolFactory).marshall((GetAccountBalanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccountBalanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccountBalance");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountBalanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAccountBalanceResult getAccountBalanceResult = (GetAccountBalanceResult)response.getAwsResponse();
            return getAccountBalanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAssignmentResult getAssignment(GetAssignmentRequest request) {
        request = (GetAssignmentRequest)this.beforeClientExecution(request);
        return this.executeGetAssignment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAssignmentResult executeGetAssignment(GetAssignmentRequest getAssignmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAssignmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAssignmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAssignmentRequestProtocolMarshaller(protocolFactory).marshall((GetAssignmentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAssignmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAssignment");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAssignmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAssignmentResult getAssignmentResult = (GetAssignmentResult)response.getAwsResponse();
            return getAssignmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFileUploadURLResult getFileUploadURL(GetFileUploadURLRequest request) {
        request = (GetFileUploadURLRequest)this.beforeClientExecution(request);
        return this.executeGetFileUploadURL(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFileUploadURLResult executeGetFileUploadURL(GetFileUploadURLRequest getFileUploadURLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFileUploadURLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFileUploadURLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFileUploadURLRequestProtocolMarshaller(protocolFactory).marshall((GetFileUploadURLRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFileUploadURLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFileUploadURL");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFileUploadURLResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFileUploadURLResult getFileUploadURLResult = (GetFileUploadURLResult)response.getAwsResponse();
            return getFileUploadURLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetHITResult getHIT(GetHITRequest request) {
        request = (GetHITRequest)this.beforeClientExecution(request);
        return this.executeGetHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetHITResult executeGetHIT(GetHITRequest getHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetHITRequestProtocolMarshaller(protocolFactory).marshall((GetHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)getHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetHITResult getHITResult = (GetHITResult)response.getAwsResponse();
            return getHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQualificationScoreResult getQualificationScore(GetQualificationScoreRequest request) {
        request = (GetQualificationScoreRequest)this.beforeClientExecution(request);
        return this.executeGetQualificationScore(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQualificationScoreResult executeGetQualificationScore(GetQualificationScoreRequest getQualificationScoreRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQualificationScoreRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQualificationScoreRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQualificationScoreRequestProtocolMarshaller(protocolFactory).marshall((GetQualificationScoreRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQualificationScoreRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQualificationScore");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQualificationScoreResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQualificationScoreResult getQualificationScoreResult = (GetQualificationScoreResult)response.getAwsResponse();
            return getQualificationScoreResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQualificationTypeResult getQualificationType(GetQualificationTypeRequest request) {
        request = (GetQualificationTypeRequest)this.beforeClientExecution(request);
        return this.executeGetQualificationType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQualificationTypeResult executeGetQualificationType(GetQualificationTypeRequest getQualificationTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQualificationTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQualificationTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQualificationTypeRequestProtocolMarshaller(protocolFactory).marshall((GetQualificationTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQualificationTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQualificationType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQualificationTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetQualificationTypeResult getQualificationTypeResult = (GetQualificationTypeResult)response.getAwsResponse();
            return getQualificationTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssignmentsForHITResult listAssignmentsForHIT(ListAssignmentsForHITRequest request) {
        request = (ListAssignmentsForHITRequest)this.beforeClientExecution(request);
        return this.executeListAssignmentsForHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssignmentsForHITResult executeListAssignmentsForHIT(ListAssignmentsForHITRequest listAssignmentsForHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssignmentsForHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssignmentsForHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssignmentsForHITRequestProtocolMarshaller(protocolFactory).marshall((ListAssignmentsForHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssignmentsForHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAssignmentsForHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssignmentsForHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssignmentsForHITResult listAssignmentsForHITResult = (ListAssignmentsForHITResult)response.getAwsResponse();
            return listAssignmentsForHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBonusPaymentsResult listBonusPayments(ListBonusPaymentsRequest request) {
        request = (ListBonusPaymentsRequest)this.beforeClientExecution(request);
        return this.executeListBonusPayments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBonusPaymentsResult executeListBonusPayments(ListBonusPaymentsRequest listBonusPaymentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBonusPaymentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBonusPaymentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBonusPaymentsRequestProtocolMarshaller(protocolFactory).marshall((ListBonusPaymentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBonusPaymentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListBonusPayments");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBonusPaymentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBonusPaymentsResult listBonusPaymentsResult = (ListBonusPaymentsResult)response.getAwsResponse();
            return listBonusPaymentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHITsResult listHITs(ListHITsRequest request) {
        request = (ListHITsRequest)this.beforeClientExecution(request);
        return this.executeListHITs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHITsResult executeListHITs(ListHITsRequest listHITsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHITsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHITsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHITsRequestProtocolMarshaller(protocolFactory).marshall((ListHITsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHITsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHITs");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHITsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHITsResult listHITsResult = (ListHITsResult)response.getAwsResponse();
            return listHITsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHITsForQualificationTypeResult listHITsForQualificationType(ListHITsForQualificationTypeRequest request) {
        request = (ListHITsForQualificationTypeRequest)this.beforeClientExecution(request);
        return this.executeListHITsForQualificationType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHITsForQualificationTypeResult executeListHITsForQualificationType(ListHITsForQualificationTypeRequest listHITsForQualificationTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHITsForQualificationTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHITsForQualificationTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHITsForQualificationTypeRequestProtocolMarshaller(protocolFactory).marshall((ListHITsForQualificationTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHITsForQualificationTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHITsForQualificationType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHITsForQualificationTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHITsForQualificationTypeResult listHITsForQualificationTypeResult = (ListHITsForQualificationTypeResult)response.getAwsResponse();
            return listHITsForQualificationTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQualificationRequestsResult listQualificationRequests(ListQualificationRequestsRequest request) {
        request = (ListQualificationRequestsRequest)this.beforeClientExecution(request);
        return this.executeListQualificationRequests(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQualificationRequestsResult executeListQualificationRequests(ListQualificationRequestsRequest listQualificationRequestsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQualificationRequestsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQualificationRequestsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQualificationRequestsRequestProtocolMarshaller(protocolFactory).marshall((ListQualificationRequestsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQualificationRequestsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQualificationRequests");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQualificationRequestsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQualificationRequestsResult listQualificationRequestsResult = (ListQualificationRequestsResult)response.getAwsResponse();
            return listQualificationRequestsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQualificationTypesResult listQualificationTypes(ListQualificationTypesRequest request) {
        request = (ListQualificationTypesRequest)this.beforeClientExecution(request);
        return this.executeListQualificationTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQualificationTypesResult executeListQualificationTypes(ListQualificationTypesRequest listQualificationTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQualificationTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQualificationTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQualificationTypesRequestProtocolMarshaller(protocolFactory).marshall((ListQualificationTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQualificationTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQualificationTypes");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQualificationTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListQualificationTypesResult listQualificationTypesResult = (ListQualificationTypesResult)response.getAwsResponse();
            return listQualificationTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReviewPolicyResultsForHITResult listReviewPolicyResultsForHIT(ListReviewPolicyResultsForHITRequest request) {
        request = (ListReviewPolicyResultsForHITRequest)this.beforeClientExecution(request);
        return this.executeListReviewPolicyResultsForHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReviewPolicyResultsForHITResult executeListReviewPolicyResultsForHIT(ListReviewPolicyResultsForHITRequest listReviewPolicyResultsForHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReviewPolicyResultsForHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReviewPolicyResultsForHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReviewPolicyResultsForHITRequestProtocolMarshaller(protocolFactory).marshall((ListReviewPolicyResultsForHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReviewPolicyResultsForHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReviewPolicyResultsForHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReviewPolicyResultsForHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReviewPolicyResultsForHITResult listReviewPolicyResultsForHITResult = (ListReviewPolicyResultsForHITResult)response.getAwsResponse();
            return listReviewPolicyResultsForHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReviewableHITsResult listReviewableHITs(ListReviewableHITsRequest request) {
        request = (ListReviewableHITsRequest)this.beforeClientExecution(request);
        return this.executeListReviewableHITs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReviewableHITsResult executeListReviewableHITs(ListReviewableHITsRequest listReviewableHITsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReviewableHITsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReviewableHITsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReviewableHITsRequestProtocolMarshaller(protocolFactory).marshall((ListReviewableHITsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReviewableHITsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReviewableHITs");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReviewableHITsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReviewableHITsResult listReviewableHITsResult = (ListReviewableHITsResult)response.getAwsResponse();
            return listReviewableHITsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkerBlocksResult listWorkerBlocks(ListWorkerBlocksRequest request) {
        request = (ListWorkerBlocksRequest)this.beforeClientExecution(request);
        return this.executeListWorkerBlocks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkerBlocksResult executeListWorkerBlocks(ListWorkerBlocksRequest listWorkerBlocksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkerBlocksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkerBlocksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkerBlocksRequestProtocolMarshaller(protocolFactory).marshall((ListWorkerBlocksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkerBlocksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkerBlocks");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkerBlocksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkerBlocksResult listWorkerBlocksResult = (ListWorkerBlocksResult)response.getAwsResponse();
            return listWorkerBlocksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkersWithQualificationTypeResult listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest request) {
        request = (ListWorkersWithQualificationTypeRequest)this.beforeClientExecution(request);
        return this.executeListWorkersWithQualificationType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkersWithQualificationTypeResult executeListWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkersWithQualificationTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkersWithQualificationTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkersWithQualificationTypeRequestProtocolMarshaller(protocolFactory).marshall((ListWorkersWithQualificationTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkersWithQualificationTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkersWithQualificationType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkersWithQualificationTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListWorkersWithQualificationTypeResult listWorkersWithQualificationTypeResult = (ListWorkersWithQualificationTypeResult)response.getAwsResponse();
            return listWorkersWithQualificationTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public NotifyWorkersResult notifyWorkers(NotifyWorkersRequest request) {
        request = (NotifyWorkersRequest)this.beforeClientExecution(request);
        return this.executeNotifyWorkers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final NotifyWorkersResult executeNotifyWorkers(NotifyWorkersRequest notifyWorkersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(notifyWorkersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<NotifyWorkersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new NotifyWorkersRequestProtocolMarshaller(protocolFactory).marshall((NotifyWorkersRequest)super.beforeMarshalling((AmazonWebServiceRequest)notifyWorkersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"NotifyWorkers");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyWorkersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            NotifyWorkersResult notifyWorkersResult = (NotifyWorkersResult)response.getAwsResponse();
            return notifyWorkersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RejectAssignmentResult rejectAssignment(RejectAssignmentRequest request) {
        request = (RejectAssignmentRequest)this.beforeClientExecution(request);
        return this.executeRejectAssignment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RejectAssignmentResult executeRejectAssignment(RejectAssignmentRequest rejectAssignmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rejectAssignmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RejectAssignmentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RejectAssignmentRequestProtocolMarshaller(protocolFactory).marshall((RejectAssignmentRequest)super.beforeMarshalling((AmazonWebServiceRequest)rejectAssignmentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RejectAssignment");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectAssignmentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RejectAssignmentResult rejectAssignmentResult = (RejectAssignmentResult)response.getAwsResponse();
            return rejectAssignmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RejectQualificationRequestResult rejectQualificationRequest(RejectQualificationRequestRequest request) {
        request = (RejectQualificationRequestRequest)this.beforeClientExecution(request);
        return this.executeRejectQualificationRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RejectQualificationRequestResult executeRejectQualificationRequest(RejectQualificationRequestRequest rejectQualificationRequestRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rejectQualificationRequestRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RejectQualificationRequestRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RejectQualificationRequestRequestProtocolMarshaller(protocolFactory).marshall((RejectQualificationRequestRequest)super.beforeMarshalling((AmazonWebServiceRequest)rejectQualificationRequestRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RejectQualificationRequest");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectQualificationRequestResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RejectQualificationRequestResult rejectQualificationRequestResult = (RejectQualificationRequestResult)response.getAwsResponse();
            return rejectQualificationRequestResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendBonusResult sendBonus(SendBonusRequest request) {
        request = (SendBonusRequest)this.beforeClientExecution(request);
        return this.executeSendBonus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendBonusResult executeSendBonus(SendBonusRequest sendBonusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendBonusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendBonusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendBonusRequestProtocolMarshaller(protocolFactory).marshall((SendBonusRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendBonusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendBonus");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendBonusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendBonusResult sendBonusResult = (SendBonusResult)response.getAwsResponse();
            return sendBonusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendTestEventNotificationResult sendTestEventNotification(SendTestEventNotificationRequest request) {
        request = (SendTestEventNotificationRequest)this.beforeClientExecution(request);
        return this.executeSendTestEventNotification(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendTestEventNotificationResult executeSendTestEventNotification(SendTestEventNotificationRequest sendTestEventNotificationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendTestEventNotificationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendTestEventNotificationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendTestEventNotificationRequestProtocolMarshaller(protocolFactory).marshall((SendTestEventNotificationRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendTestEventNotificationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendTestEventNotification");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendTestEventNotificationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendTestEventNotificationResult sendTestEventNotificationResult = (SendTestEventNotificationResult)response.getAwsResponse();
            return sendTestEventNotificationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateExpirationForHITResult updateExpirationForHIT(UpdateExpirationForHITRequest request) {
        request = (UpdateExpirationForHITRequest)this.beforeClientExecution(request);
        return this.executeUpdateExpirationForHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateExpirationForHITResult executeUpdateExpirationForHIT(UpdateExpirationForHITRequest updateExpirationForHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateExpirationForHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateExpirationForHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateExpirationForHITRequestProtocolMarshaller(protocolFactory).marshall((UpdateExpirationForHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateExpirationForHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateExpirationForHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateExpirationForHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateExpirationForHITResult updateExpirationForHITResult = (UpdateExpirationForHITResult)response.getAwsResponse();
            return updateExpirationForHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateHITReviewStatusResult updateHITReviewStatus(UpdateHITReviewStatusRequest request) {
        request = (UpdateHITReviewStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateHITReviewStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateHITReviewStatusResult executeUpdateHITReviewStatus(UpdateHITReviewStatusRequest updateHITReviewStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateHITReviewStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateHITReviewStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateHITReviewStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateHITReviewStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateHITReviewStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateHITReviewStatus");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateHITReviewStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateHITReviewStatusResult updateHITReviewStatusResult = (UpdateHITReviewStatusResult)response.getAwsResponse();
            return updateHITReviewStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateHITTypeOfHITResult updateHITTypeOfHIT(UpdateHITTypeOfHITRequest request) {
        request = (UpdateHITTypeOfHITRequest)this.beforeClientExecution(request);
        return this.executeUpdateHITTypeOfHIT(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateHITTypeOfHITResult executeUpdateHITTypeOfHIT(UpdateHITTypeOfHITRequest updateHITTypeOfHITRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateHITTypeOfHITRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateHITTypeOfHITRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateHITTypeOfHITRequestProtocolMarshaller(protocolFactory).marshall((UpdateHITTypeOfHITRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateHITTypeOfHITRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateHITTypeOfHIT");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateHITTypeOfHITResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateHITTypeOfHITResult updateHITTypeOfHITResult = (UpdateHITTypeOfHITResult)response.getAwsResponse();
            return updateHITTypeOfHITResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNotificationSettingsResult updateNotificationSettings(UpdateNotificationSettingsRequest request) {
        request = (UpdateNotificationSettingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateNotificationSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNotificationSettingsResult executeUpdateNotificationSettings(UpdateNotificationSettingsRequest updateNotificationSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNotificationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNotificationSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNotificationSettingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateNotificationSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateNotificationSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateNotificationSettings");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateNotificationSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNotificationSettingsResult updateNotificationSettingsResult = (UpdateNotificationSettingsResult)response.getAwsResponse();
            return updateNotificationSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateQualificationTypeResult updateQualificationType(UpdateQualificationTypeRequest request) {
        request = (UpdateQualificationTypeRequest)this.beforeClientExecution(request);
        return this.executeUpdateQualificationType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateQualificationTypeResult executeUpdateQualificationType(UpdateQualificationTypeRequest updateQualificationTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateQualificationTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateQualificationTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateQualificationTypeRequestProtocolMarshaller(protocolFactory).marshall((UpdateQualificationTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateQualificationTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MTurk");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateQualificationType");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateQualificationTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateQualificationTypeResult updateQualificationTypeResult = (UpdateQualificationTypeResult)response.getAwsResponse();
            return updateQualificationTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

