/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class MeterUsageRequestMarshaller
implements Marshaller<Request<MeterUsageRequest>, MeterUsageRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public MeterUsageRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<MeterUsageRequest> marshall(MeterUsageRequest meterUsageRequest) {
        if (meterUsageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)meterUsageRequest, "AWSMarketplaceMetering");
        request.addHeader("X-Amz-Target", "AWSMPMeteringService.MeterUsage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (meterUsageRequest.getProductCode() != null) {
                jsonGenerator.writeFieldName("ProductCode").writeValue(meterUsageRequest.getProductCode());
            }
            if (meterUsageRequest.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(meterUsageRequest.getTimestamp());
            }
            if (meterUsageRequest.getUsageDimension() != null) {
                jsonGenerator.writeFieldName("UsageDimension").writeValue(meterUsageRequest.getUsageDimension());
            }
            if (meterUsageRequest.getUsageQuantity() != null) {
                jsonGenerator.writeFieldName("UsageQuantity").writeValue(meterUsageRequest.getUsageQuantity().intValue());
            }
            if (meterUsageRequest.getDryRun() != null) {
                jsonGenerator.writeFieldName("DryRun").writeValue(meterUsageRequest.getDryRun().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

