/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.marketplacemetering.model.UsageRecord;
import com.amazonaws.services.marketplacemetering.model.UsageRecordResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchMeterUsageResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<UsageRecordResult> results;
    private List<UsageRecord> unprocessedRecords;

    public List<UsageRecordResult> getResults() {
        return this.results;
    }

    public void setResults(Collection<UsageRecordResult> results) {
        if (results == null) {
            this.results = null;
            return;
        }
        this.results = new ArrayList<UsageRecordResult>(results);
    }

    public BatchMeterUsageResult withResults(UsageRecordResult ... results) {
        if (this.results == null) {
            this.setResults(new ArrayList<UsageRecordResult>(results.length));
        }
        for (UsageRecordResult ele : results) {
            this.results.add(ele);
        }
        return this;
    }

    public BatchMeterUsageResult withResults(Collection<UsageRecordResult> results) {
        this.setResults(results);
        return this;
    }

    public List<UsageRecord> getUnprocessedRecords() {
        return this.unprocessedRecords;
    }

    public void setUnprocessedRecords(Collection<UsageRecord> unprocessedRecords) {
        if (unprocessedRecords == null) {
            this.unprocessedRecords = null;
            return;
        }
        this.unprocessedRecords = new ArrayList<UsageRecord>(unprocessedRecords);
    }

    public BatchMeterUsageResult withUnprocessedRecords(UsageRecord ... unprocessedRecords) {
        if (this.unprocessedRecords == null) {
            this.setUnprocessedRecords(new ArrayList<UsageRecord>(unprocessedRecords.length));
        }
        for (UsageRecord ele : unprocessedRecords) {
            this.unprocessedRecords.add(ele);
        }
        return this;
    }

    public BatchMeterUsageResult withUnprocessedRecords(Collection<UsageRecord> unprocessedRecords) {
        this.setUnprocessedRecords(unprocessedRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResults() != null) {
            sb.append("Results: " + this.getResults() + ",");
        }
        if (this.getUnprocessedRecords() != null) {
            sb.append("UnprocessedRecords: " + this.getUnprocessedRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMeterUsageResult)) {
            return false;
        }
        BatchMeterUsageResult other = (BatchMeterUsageResult)obj;
        if (other.getResults() == null ^ this.getResults() == null) {
            return false;
        }
        if (other.getResults() != null && !other.getResults().equals(this.getResults())) {
            return false;
        }
        if (other.getUnprocessedRecords() == null ^ this.getUnprocessedRecords() == null) {
            return false;
        }
        return other.getUnprocessedRecords() == null || other.getUnprocessedRecords().equals(this.getUnprocessedRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResults() == null ? 0 : this.getResults().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedRecords() == null ? 0 : this.getUnprocessedRecords().hashCode());
        return hashCode;
    }

    public BatchMeterUsageResult clone() {
        try {
            return (BatchMeterUsageResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

