/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.marketplacemetering.AWSMarketplaceMetering;
import com.amazonaws.services.marketplacemetering.model.DuplicateRequestException;
import com.amazonaws.services.marketplacemetering.model.InternalServiceErrorException;
import com.amazonaws.services.marketplacemetering.model.InvalidEndpointRegionException;
import com.amazonaws.services.marketplacemetering.model.InvalidProductCodeException;
import com.amazonaws.services.marketplacemetering.model.InvalidUsageDimensionException;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.services.marketplacemetering.model.MeterUsageResult;
import com.amazonaws.services.marketplacemetering.model.ThrottlingException;
import com.amazonaws.services.marketplacemetering.model.TimestampOutOfBoundsException;
import com.amazonaws.services.marketplacemetering.model.transform.MeterUsageRequestMarshaller;
import com.amazonaws.services.marketplacemetering.model.transform.MeterUsageResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMarketplaceMeteringClient
extends AmazonWebServiceClient
implements AWSMarketplaceMetering {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMarketplaceMetering.class);
    private static final String DEFAULT_SIGNING_NAME = "aws-marketplace";
    private static final String DEFAULT_ENDPOINT_PREFIX = "metering.marketplace";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSMarketplaceMeteringClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSMarketplaceMeteringClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSMarketplaceMeteringClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSMarketplaceMeteringClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSMarketplaceMeteringClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TimestampOutOfBoundsException.class, "TimestampOutOfBoundsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalServiceErrorException.class, "InternalServiceErrorException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidUsageDimensionException.class, "InvalidUsageDimensionException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ThrottlingException.class, "ThrottlingException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(DuplicateRequestException.class, "DuplicateRequestException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidEndpointRegionException.class, "InvalidEndpointRegionException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidProductCodeException.class, "InvalidProductCodeException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_ENDPOINT_PREFIX);
        this.setEndpoint("https://metering.marketplace.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/marketplacemetering/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/marketplacemetering/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeterUsageResult meterUsage(MeterUsageRequest meterUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(meterUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<MeterUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new MeterUsageRequestMarshaller().marshall((MeterUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)meterUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new MeterUsageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            MeterUsageResult meterUsageResult = (MeterUsageResult)response.getAwsResponse();
            return meterUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

