/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchainquery.model.ContractIdentifier;
import com.amazonaws.services.managedblockchainquery.model.QueryTokenStandard;
import com.amazonaws.services.managedblockchainquery.model.transform.AssetContractMarshaller;
import java.io.Serializable;

public class AssetContract
implements Serializable,
Cloneable,
StructuredPojo {
    private ContractIdentifier contractIdentifier;
    private String tokenStandard;
    private String deployerAddress;

    public void setContractIdentifier(ContractIdentifier contractIdentifier) {
        this.contractIdentifier = contractIdentifier;
    }

    public ContractIdentifier getContractIdentifier() {
        return this.contractIdentifier;
    }

    public AssetContract withContractIdentifier(ContractIdentifier contractIdentifier) {
        this.setContractIdentifier(contractIdentifier);
        return this;
    }

    public void setTokenStandard(String tokenStandard) {
        this.tokenStandard = tokenStandard;
    }

    public String getTokenStandard() {
        return this.tokenStandard;
    }

    public AssetContract withTokenStandard(String tokenStandard) {
        this.setTokenStandard(tokenStandard);
        return this;
    }

    public AssetContract withTokenStandard(QueryTokenStandard tokenStandard) {
        this.tokenStandard = tokenStandard.toString();
        return this;
    }

    public void setDeployerAddress(String deployerAddress) {
        this.deployerAddress = deployerAddress;
    }

    public String getDeployerAddress() {
        return this.deployerAddress;
    }

    public AssetContract withDeployerAddress(String deployerAddress) {
        this.setDeployerAddress(deployerAddress);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContractIdentifier() != null) {
            sb.append("ContractIdentifier: ").append(this.getContractIdentifier()).append(",");
        }
        if (this.getTokenStandard() != null) {
            sb.append("TokenStandard: ").append(this.getTokenStandard()).append(",");
        }
        if (this.getDeployerAddress() != null) {
            sb.append("DeployerAddress: ").append(this.getDeployerAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetContract)) {
            return false;
        }
        AssetContract other = (AssetContract)obj;
        if (other.getContractIdentifier() == null ^ this.getContractIdentifier() == null) {
            return false;
        }
        if (other.getContractIdentifier() != null && !other.getContractIdentifier().equals(this.getContractIdentifier())) {
            return false;
        }
        if (other.getTokenStandard() == null ^ this.getTokenStandard() == null) {
            return false;
        }
        if (other.getTokenStandard() != null && !other.getTokenStandard().equals(this.getTokenStandard())) {
            return false;
        }
        if (other.getDeployerAddress() == null ^ this.getDeployerAddress() == null) {
            return false;
        }
        return other.getDeployerAddress() == null || other.getDeployerAddress().equals(this.getDeployerAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContractIdentifier() == null ? 0 : this.getContractIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTokenStandard() == null ? 0 : this.getTokenStandard().hashCode());
        hashCode = 31 * hashCode + (this.getDeployerAddress() == null ? 0 : this.getDeployerAddress().hashCode());
        return hashCode;
    }

    public AssetContract clone() {
        try {
            return (AssetContract)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssetContractMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

