/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.managedblockchainquery.model.AssetContract;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAssetContractsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AssetContract> contracts;
    private String nextToken;

    public List<AssetContract> getContracts() {
        return this.contracts;
    }

    public void setContracts(Collection<AssetContract> contracts) {
        if (contracts == null) {
            this.contracts = null;
            return;
        }
        this.contracts = new ArrayList<AssetContract>(contracts);
    }

    public ListAssetContractsResult withContracts(AssetContract ... contracts) {
        if (this.contracts == null) {
            this.setContracts(new ArrayList<AssetContract>(contracts.length));
        }
        for (AssetContract ele : contracts) {
            this.contracts.add(ele);
        }
        return this;
    }

    public ListAssetContractsResult withContracts(Collection<AssetContract> contracts) {
        this.setContracts(contracts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAssetContractsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContracts() != null) {
            sb.append("Contracts: ").append(this.getContracts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetContractsResult)) {
            return false;
        }
        ListAssetContractsResult other = (ListAssetContractsResult)obj;
        if (other.getContracts() == null ^ this.getContracts() == null) {
            return false;
        }
        if (other.getContracts() != null && !other.getContracts().equals(this.getContracts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContracts() == null ? 0 : this.getContracts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAssetContractsResult clone() {
        try {
            return (ListAssetContractsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

