/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchain.model.NetworkFrameworkAttributes;

@SdkInternalApi
public class NetworkFrameworkAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> FABRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Fabric").build();
    private static final MarshallingInfo<StructuredPojo> ETHEREUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ethereum").build();
    private static final NetworkFrameworkAttributesMarshaller instance = new NetworkFrameworkAttributesMarshaller();

    public static NetworkFrameworkAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkFrameworkAttributes networkFrameworkAttributes, ProtocolMarshaller protocolMarshaller) {
        if (networkFrameworkAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkFrameworkAttributes.getFabric(), FABRIC_BINDING);
            protocolMarshaller.marshall((Object)networkFrameworkAttributes.getEthereum(), ETHEREUM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

