/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.managedblockchain.AmazonManagedBlockchain;
import com.amazonaws.services.managedblockchain.AmazonManagedBlockchainClientBuilder;
import com.amazonaws.services.managedblockchain.model.AccessDeniedException;
import com.amazonaws.services.managedblockchain.model.AmazonManagedBlockchainException;
import com.amazonaws.services.managedblockchain.model.CreateMemberRequest;
import com.amazonaws.services.managedblockchain.model.CreateMemberResult;
import com.amazonaws.services.managedblockchain.model.CreateNetworkRequest;
import com.amazonaws.services.managedblockchain.model.CreateNetworkResult;
import com.amazonaws.services.managedblockchain.model.CreateNodeRequest;
import com.amazonaws.services.managedblockchain.model.CreateNodeResult;
import com.amazonaws.services.managedblockchain.model.CreateProposalRequest;
import com.amazonaws.services.managedblockchain.model.CreateProposalResult;
import com.amazonaws.services.managedblockchain.model.DeleteMemberRequest;
import com.amazonaws.services.managedblockchain.model.DeleteMemberResult;
import com.amazonaws.services.managedblockchain.model.DeleteNodeRequest;
import com.amazonaws.services.managedblockchain.model.DeleteNodeResult;
import com.amazonaws.services.managedblockchain.model.GetMemberRequest;
import com.amazonaws.services.managedblockchain.model.GetMemberResult;
import com.amazonaws.services.managedblockchain.model.GetNetworkRequest;
import com.amazonaws.services.managedblockchain.model.GetNetworkResult;
import com.amazonaws.services.managedblockchain.model.GetNodeRequest;
import com.amazonaws.services.managedblockchain.model.GetNodeResult;
import com.amazonaws.services.managedblockchain.model.GetProposalRequest;
import com.amazonaws.services.managedblockchain.model.GetProposalResult;
import com.amazonaws.services.managedblockchain.model.IllegalActionException;
import com.amazonaws.services.managedblockchain.model.InternalServiceErrorException;
import com.amazonaws.services.managedblockchain.model.InvalidRequestException;
import com.amazonaws.services.managedblockchain.model.ListInvitationsRequest;
import com.amazonaws.services.managedblockchain.model.ListInvitationsResult;
import com.amazonaws.services.managedblockchain.model.ListMembersRequest;
import com.amazonaws.services.managedblockchain.model.ListMembersResult;
import com.amazonaws.services.managedblockchain.model.ListNetworksRequest;
import com.amazonaws.services.managedblockchain.model.ListNetworksResult;
import com.amazonaws.services.managedblockchain.model.ListNodesRequest;
import com.amazonaws.services.managedblockchain.model.ListNodesResult;
import com.amazonaws.services.managedblockchain.model.ListProposalVotesRequest;
import com.amazonaws.services.managedblockchain.model.ListProposalVotesResult;
import com.amazonaws.services.managedblockchain.model.ListProposalsRequest;
import com.amazonaws.services.managedblockchain.model.ListProposalsResult;
import com.amazonaws.services.managedblockchain.model.RejectInvitationRequest;
import com.amazonaws.services.managedblockchain.model.RejectInvitationResult;
import com.amazonaws.services.managedblockchain.model.ResourceAlreadyExistsException;
import com.amazonaws.services.managedblockchain.model.ResourceLimitExceededException;
import com.amazonaws.services.managedblockchain.model.ResourceNotFoundException;
import com.amazonaws.services.managedblockchain.model.ResourceNotReadyException;
import com.amazonaws.services.managedblockchain.model.ThrottlingException;
import com.amazonaws.services.managedblockchain.model.VoteOnProposalRequest;
import com.amazonaws.services.managedblockchain.model.VoteOnProposalResult;
import com.amazonaws.services.managedblockchain.model.transform.CreateMemberRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateMemberResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateNetworkRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateNetworkResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateNodeRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateNodeResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateProposalRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.CreateProposalResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.DeleteMemberRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.DeleteMemberResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.DeleteNodeRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.DeleteNodeResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetMemberRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetMemberResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetNetworkRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetNetworkResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetNodeRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetNodeResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetProposalRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.GetProposalResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListInvitationsRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListInvitationsResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListMembersRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListMembersResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListNetworksRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListNetworksResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListNodesRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListNodesResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListProposalVotesRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListProposalVotesResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListProposalsRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.ListProposalsResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.RejectInvitationRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.RejectInvitationResultJsonUnmarshaller;
import com.amazonaws.services.managedblockchain.model.transform.VoteOnProposalRequestProtocolMarshaller;
import com.amazonaws.services.managedblockchain.model.transform.VoteOnProposalResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonManagedBlockchainClient
extends AmazonWebServiceClient
implements AmazonManagedBlockchain {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonManagedBlockchain.class);
    private static final String DEFAULT_SIGNING_NAME = "managedblockchain";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotReadyException").withModeledClass(ResourceNotReadyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withModeledClass(InternalServiceErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IllegalActionException").withModeledClass(IllegalActionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withModeledClass(ResourceLimitExceededException.class)).withBaseServiceExceptionClass(AmazonManagedBlockchainException.class));

    public static AmazonManagedBlockchainClientBuilder builder() {
        return AmazonManagedBlockchainClientBuilder.standard();
    }

    AmazonManagedBlockchainClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonManagedBlockchainClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("managedblockchain.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/managedblockchain/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/managedblockchain/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateMemberResult createMember(CreateMemberRequest request) {
        request = (CreateMemberRequest)this.beforeClientExecution(request);
        return this.executeCreateMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMemberResult executeCreateMember(CreateMemberRequest createMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMemberRequestProtocolMarshaller(protocolFactory).marshall((CreateMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMemberResult createMemberResult = (CreateMemberResult)response.getAwsResponse();
            return createMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNetworkResult createNetwork(CreateNetworkRequest request) {
        request = (CreateNetworkRequest)this.beforeClientExecution(request);
        return this.executeCreateNetwork(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNetworkResult executeCreateNetwork(CreateNetworkRequest createNetworkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNetworkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNetworkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNetworkRequestProtocolMarshaller(protocolFactory).marshall((CreateNetworkRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNetworkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateNetwork");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNetworkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNetworkResult createNetworkResult = (CreateNetworkResult)response.getAwsResponse();
            return createNetworkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateNodeResult createNode(CreateNodeRequest request) {
        request = (CreateNodeRequest)this.beforeClientExecution(request);
        return this.executeCreateNode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNodeResult executeCreateNode(CreateNodeRequest createNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNodeRequestProtocolMarshaller(protocolFactory).marshall((CreateNodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateNode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNodeResult createNodeResult = (CreateNodeResult)response.getAwsResponse();
            return createNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProposalResult createProposal(CreateProposalRequest request) {
        request = (CreateProposalRequest)this.beforeClientExecution(request);
        return this.executeCreateProposal(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProposalResult executeCreateProposal(CreateProposalRequest createProposalRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProposalRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProposalRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProposalRequestProtocolMarshaller(protocolFactory).marshall((CreateProposalRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProposalRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProposal");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProposalResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProposalResult createProposalResult = (CreateProposalResult)response.getAwsResponse();
            return createProposalResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMemberResult deleteMember(DeleteMemberRequest request) {
        request = (DeleteMemberRequest)this.beforeClientExecution(request);
        return this.executeDeleteMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMemberResult executeDeleteMember(DeleteMemberRequest deleteMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMemberRequestProtocolMarshaller(protocolFactory).marshall((DeleteMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMemberResult deleteMemberResult = (DeleteMemberResult)response.getAwsResponse();
            return deleteMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNodeResult deleteNode(DeleteNodeRequest request) {
        request = (DeleteNodeRequest)this.beforeClientExecution(request);
        return this.executeDeleteNode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNodeResult executeDeleteNode(DeleteNodeRequest deleteNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNodeRequestProtocolMarshaller(protocolFactory).marshall((DeleteNodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNodeResult deleteNodeResult = (DeleteNodeResult)response.getAwsResponse();
            return deleteNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMemberResult getMember(GetMemberRequest request) {
        request = (GetMemberRequest)this.beforeClientExecution(request);
        return this.executeGetMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMemberResult executeGetMember(GetMemberRequest getMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMemberRequestProtocolMarshaller(protocolFactory).marshall((GetMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMemberResult getMemberResult = (GetMemberResult)response.getAwsResponse();
            return getMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNetworkResult getNetwork(GetNetworkRequest request) {
        request = (GetNetworkRequest)this.beforeClientExecution(request);
        return this.executeGetNetwork(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNetworkResult executeGetNetwork(GetNetworkRequest getNetworkRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNetworkRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNetworkRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNetworkRequestProtocolMarshaller(protocolFactory).marshall((GetNetworkRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNetworkRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNetwork");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNetworkResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNetworkResult getNetworkResult = (GetNetworkResult)response.getAwsResponse();
            return getNetworkResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNodeResult getNode(GetNodeRequest request) {
        request = (GetNodeRequest)this.beforeClientExecution(request);
        return this.executeGetNode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNodeResult executeGetNode(GetNodeRequest getNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNodeRequestProtocolMarshaller(protocolFactory).marshall((GetNodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNodeResult getNodeResult = (GetNodeResult)response.getAwsResponse();
            return getNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProposalResult getProposal(GetProposalRequest request) {
        request = (GetProposalRequest)this.beforeClientExecution(request);
        return this.executeGetProposal(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProposalResult executeGetProposal(GetProposalRequest getProposalRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProposalRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProposalRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProposalRequestProtocolMarshaller(protocolFactory).marshall((GetProposalRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProposalRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProposal");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProposalResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProposalResult getProposalResult = (GetProposalResult)response.getAwsResponse();
            return getProposalResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        request = (ListInvitationsRequest)this.beforeClientExecution(request);
        return this.executeListInvitations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInvitationsResult executeListInvitations(ListInvitationsRequest listInvitationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInvitationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInvitationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInvitationsRequestProtocolMarshaller(protocolFactory).marshall((ListInvitationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInvitationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInvitations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInvitationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInvitationsResult listInvitationsResult = (ListInvitationsResult)response.getAwsResponse();
            return listInvitationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        request = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executeListMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMembersResult executeListMembers(ListMembersRequest listMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMembersRequestProtocolMarshaller(protocolFactory).marshall((ListMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMembersResult listMembersResult = (ListMembersResult)response.getAwsResponse();
            return listMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNetworksResult listNetworks(ListNetworksRequest request) {
        request = (ListNetworksRequest)this.beforeClientExecution(request);
        return this.executeListNetworks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNetworksResult executeListNetworks(ListNetworksRequest listNetworksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNetworksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNetworksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNetworksRequestProtocolMarshaller(protocolFactory).marshall((ListNetworksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNetworksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNetworks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNetworksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNetworksResult listNetworksResult = (ListNetworksResult)response.getAwsResponse();
            return listNetworksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNodesResult listNodes(ListNodesRequest request) {
        request = (ListNodesRequest)this.beforeClientExecution(request);
        return this.executeListNodes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNodesResult executeListNodes(ListNodesRequest listNodesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNodesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNodesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNodesRequestProtocolMarshaller(protocolFactory).marshall((ListNodesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listNodesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListNodes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListNodesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNodesResult listNodesResult = (ListNodesResult)response.getAwsResponse();
            return listNodesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProposalVotesResult listProposalVotes(ListProposalVotesRequest request) {
        request = (ListProposalVotesRequest)this.beforeClientExecution(request);
        return this.executeListProposalVotes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProposalVotesResult executeListProposalVotes(ListProposalVotesRequest listProposalVotesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProposalVotesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProposalVotesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProposalVotesRequestProtocolMarshaller(protocolFactory).marshall((ListProposalVotesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProposalVotesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProposalVotes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProposalVotesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProposalVotesResult listProposalVotesResult = (ListProposalVotesResult)response.getAwsResponse();
            return listProposalVotesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProposalsResult listProposals(ListProposalsRequest request) {
        request = (ListProposalsRequest)this.beforeClientExecution(request);
        return this.executeListProposals(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProposalsResult executeListProposals(ListProposalsRequest listProposalsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProposalsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProposalsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProposalsRequestProtocolMarshaller(protocolFactory).marshall((ListProposalsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProposalsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProposals");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProposalsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProposalsResult listProposalsResult = (ListProposalsResult)response.getAwsResponse();
            return listProposalsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RejectInvitationResult rejectInvitation(RejectInvitationRequest request) {
        request = (RejectInvitationRequest)this.beforeClientExecution(request);
        return this.executeRejectInvitation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RejectInvitationResult executeRejectInvitation(RejectInvitationRequest rejectInvitationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rejectInvitationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RejectInvitationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RejectInvitationRequestProtocolMarshaller(protocolFactory).marshall((RejectInvitationRequest)super.beforeMarshalling((AmazonWebServiceRequest)rejectInvitationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RejectInvitation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectInvitationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RejectInvitationResult rejectInvitationResult = (RejectInvitationResult)response.getAwsResponse();
            return rejectInvitationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public VoteOnProposalResult voteOnProposal(VoteOnProposalRequest request) {
        request = (VoteOnProposalRequest)this.beforeClientExecution(request);
        return this.executeVoteOnProposal(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final VoteOnProposalResult executeVoteOnProposal(VoteOnProposalRequest voteOnProposalRequest) {
        ExecutionContext executionContext = this.createExecutionContext(voteOnProposalRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VoteOnProposalRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VoteOnProposalRequestProtocolMarshaller(protocolFactory).marshall((VoteOnProposalRequest)super.beforeMarshalling((AmazonWebServiceRequest)voteOnProposalRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"ManagedBlockchain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"VoteOnProposal");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new VoteOnProposalResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            VoteOnProposalResult voteOnProposalResult = (VoteOnProposalResult)response.getAwsResponse();
            return voteOnProposalResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

