/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mainframemodernization.model.DeploymentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDeploymentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DeploymentSummary> deployments;
    private String nextToken;

    public List<DeploymentSummary> getDeployments() {
        return this.deployments;
    }

    public void setDeployments(Collection<DeploymentSummary> deployments) {
        if (deployments == null) {
            this.deployments = null;
            return;
        }
        this.deployments = new ArrayList<DeploymentSummary>(deployments);
    }

    public ListDeploymentsResult withDeployments(DeploymentSummary ... deployments) {
        if (this.deployments == null) {
            this.setDeployments(new ArrayList<DeploymentSummary>(deployments.length));
        }
        for (DeploymentSummary ele : deployments) {
            this.deployments.add(ele);
        }
        return this;
    }

    public ListDeploymentsResult withDeployments(Collection<DeploymentSummary> deployments) {
        this.setDeployments(deployments);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDeploymentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeployments() != null) {
            sb.append("Deployments: ").append(this.getDeployments()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsResult)) {
            return false;
        }
        ListDeploymentsResult other = (ListDeploymentsResult)obj;
        if (other.getDeployments() == null ^ this.getDeployments() == null) {
            return false;
        }
        if (other.getDeployments() != null && !other.getDeployments().equals(this.getDeployments())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeployments() == null ? 0 : this.getDeployments().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDeploymentsResult clone() {
        try {
            return (ListDeploymentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

