/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.mailmanager.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RuleAction JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RuleActionJsonUnmarshaller implements Unmarshaller<RuleAction, JsonUnmarshallerContext> {

    public RuleAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        RuleAction ruleAction = new RuleAction();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AddHeader", targetDepth)) {
                    context.nextToken();
                    ruleAction.setAddHeader(AddHeaderActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Archive", targetDepth)) {
                    context.nextToken();
                    ruleAction.setArchive(ArchiveActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DeliverToMailbox", targetDepth)) {
                    context.nextToken();
                    ruleAction.setDeliverToMailbox(DeliverToMailboxActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Drop", targetDepth)) {
                    context.nextToken();
                    ruleAction.setDrop(DropActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Relay", targetDepth)) {
                    context.nextToken();
                    ruleAction.setRelay(RelayActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ReplaceRecipient", targetDepth)) {
                    context.nextToken();
                    ruleAction.setReplaceRecipient(ReplaceRecipientActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Send", targetDepth)) {
                    context.nextToken();
                    ruleAction.setSend(SendActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("WriteToS3", targetDepth)) {
                    context.nextToken();
                    ruleAction.setWriteToS3(S3ActionJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return ruleAction;
    }

    private static RuleActionJsonUnmarshaller instance;

    public static RuleActionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new RuleActionJsonUnmarshaller();
        return instance;
    }
}
