/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mailmanager.model.ArchiveStringOperator;
import com.amazonaws.services.mailmanager.model.ArchiveStringToEvaluate;
import com.amazonaws.services.mailmanager.model.transform.ArchiveStringExpressionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArchiveStringExpression
implements Serializable,
Cloneable,
StructuredPojo {
    private ArchiveStringToEvaluate evaluate;
    private String operator;
    private List<String> values;

    public void setEvaluate(ArchiveStringToEvaluate evaluate) {
        this.evaluate = evaluate;
    }

    public ArchiveStringToEvaluate getEvaluate() {
        return this.evaluate;
    }

    public ArchiveStringExpression withEvaluate(ArchiveStringToEvaluate evaluate) {
        this.setEvaluate(evaluate);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public ArchiveStringExpression withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public ArchiveStringExpression withOperator(ArchiveStringOperator operator) {
        this.operator = operator.toString();
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public ArchiveStringExpression withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public ArchiveStringExpression withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvaluate() != null) {
            sb.append("Evaluate: ").append(this.getEvaluate()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveStringExpression)) {
            return false;
        }
        ArchiveStringExpression other = (ArchiveStringExpression)obj;
        if (other.getEvaluate() == null ^ this.getEvaluate() == null) {
            return false;
        }
        if (other.getEvaluate() != null && !other.getEvaluate().equals(this.getEvaluate())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        if (other.getOperator() != null && !other.getOperator().equals(this.getOperator())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvaluate() == null ? 0 : this.getEvaluate().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public ArchiveStringExpression clone() {
        try {
            return (ArchiveStringExpression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArchiveStringExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

