/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.machinelearning.AmazonMachineLearning;
import com.amazonaws.services.machinelearning.AmazonMachineLearningClientBuilder;
import com.amazonaws.services.machinelearning.model.AddTagsRequest;
import com.amazonaws.services.machinelearning.model.AddTagsResult;
import com.amazonaws.services.machinelearning.model.AmazonMachineLearningException;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftResult;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Result;
import com.amazonaws.services.machinelearning.model.CreateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.CreateEvaluationResult;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import com.amazonaws.services.machinelearning.model.CreateMLModelResult;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.CreateRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.DeleteBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceRequest;
import com.amazonaws.services.machinelearning.model.DeleteDataSourceResult;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationRequest;
import com.amazonaws.services.machinelearning.model.DeleteEvaluationResult;
import com.amazonaws.services.machinelearning.model.DeleteMLModelRequest;
import com.amazonaws.services.machinelearning.model.DeleteMLModelResult;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import com.amazonaws.services.machinelearning.model.DeleteRealtimeEndpointResult;
import com.amazonaws.services.machinelearning.model.DeleteTagsRequest;
import com.amazonaws.services.machinelearning.model.DeleteTagsResult;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsRequest;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsResult;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesRequest;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesResult;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsRequest;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsResult;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsRequest;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsResult;
import com.amazonaws.services.machinelearning.model.DescribeTagsRequest;
import com.amazonaws.services.machinelearning.model.DescribeTagsResult;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.GetBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.GetDataSourceRequest;
import com.amazonaws.services.machinelearning.model.GetDataSourceResult;
import com.amazonaws.services.machinelearning.model.GetEvaluationRequest;
import com.amazonaws.services.machinelearning.model.GetEvaluationResult;
import com.amazonaws.services.machinelearning.model.GetMLModelRequest;
import com.amazonaws.services.machinelearning.model.GetMLModelResult;
import com.amazonaws.services.machinelearning.model.IdempotentParameterMismatchException;
import com.amazonaws.services.machinelearning.model.InternalServerException;
import com.amazonaws.services.machinelearning.model.InvalidInputException;
import com.amazonaws.services.machinelearning.model.InvalidTagException;
import com.amazonaws.services.machinelearning.model.LimitExceededException;
import com.amazonaws.services.machinelearning.model.PredictRequest;
import com.amazonaws.services.machinelearning.model.PredictResult;
import com.amazonaws.services.machinelearning.model.PredictorNotMountedException;
import com.amazonaws.services.machinelearning.model.ResourceNotFoundException;
import com.amazonaws.services.machinelearning.model.TagLimitExceededException;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.UpdateBatchPredictionResult;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceRequest;
import com.amazonaws.services.machinelearning.model.UpdateDataSourceResult;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.UpdateEvaluationResult;
import com.amazonaws.services.machinelearning.model.UpdateMLModelRequest;
import com.amazonaws.services.machinelearning.model.UpdateMLModelResult;
import com.amazonaws.services.machinelearning.model.transform.AddTagsRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateBatchPredictionRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateBatchPredictionResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateDataSourceFromRDSRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateDataSourceFromRDSResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateDataSourceFromRedshiftRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateDataSourceFromRedshiftResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateDataSourceFromS3RequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateDataSourceFromS3ResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateEvaluationRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateEvaluationResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateMLModelRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateMLModelResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateRealtimeEndpointRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.CreateRealtimeEndpointResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteBatchPredictionRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteBatchPredictionResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteEvaluationRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteEvaluationResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteMLModelRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteMLModelResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteRealtimeEndpointRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteRealtimeEndpointResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteTagsRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DeleteTagsResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeBatchPredictionsRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeBatchPredictionsResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeDataSourcesRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeDataSourcesResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeEvaluationsRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeEvaluationsResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeMLModelsRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeMLModelsResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeTagsRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.DescribeTagsResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetBatchPredictionRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetBatchPredictionResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetEvaluationRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetEvaluationResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetMLModelRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.GetMLModelResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.PredictRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.PredictResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateBatchPredictionRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateBatchPredictionResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateDataSourceRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateDataSourceResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateEvaluationRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateEvaluationResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateMLModelRequestProtocolMarshaller;
import com.amazonaws.services.machinelearning.model.transform.UpdateMLModelResultJsonUnmarshaller;
import com.amazonaws.services.machinelearning.waiters.AmazonMachineLearningWaiters;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonMachineLearningClient
extends AmazonWebServiceClient
implements AmazonMachineLearning {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonMachineLearning.class);
    private static final String DEFAULT_SIGNING_NAME = "machinelearning";
    private volatile AmazonMachineLearningWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(InvalidTagException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatchException").withModeledClass(IdempotentParameterMismatchException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TagLimitExceededException").withModeledClass(TagLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withModeledClass(InternalServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PredictorNotMountedException").withModeledClass(PredictorNotMountedException.class)).withBaseServiceExceptionClass(AmazonMachineLearningException.class));

    @Deprecated
    public AmazonMachineLearningClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonMachineLearningClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonMachineLearningClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonMachineLearningClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonMachineLearningClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonMachineLearningClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonMachineLearningClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonMachineLearningClientBuilder builder() {
        return AmazonMachineLearningClientBuilder.standard();
    }

    AmazonMachineLearningClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://machinelearning.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/machinelearning/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/machinelearning/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddTagsResult addTags(AddTagsRequest request) {
        request = (AddTagsRequest)this.beforeClientExecution(request);
        return this.executeAddTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddTagsResult executeAddTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestProtocolMarshaller(protocolFactory).marshall((AddTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddTags");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AddTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBatchPredictionResult createBatchPrediction(CreateBatchPredictionRequest request) {
        request = (CreateBatchPredictionRequest)this.beforeClientExecution(request);
        return this.executeCreateBatchPrediction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBatchPredictionResult executeCreateBatchPrediction(CreateBatchPredictionRequest createBatchPredictionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBatchPredictionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBatchPredictionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBatchPredictionRequestProtocolMarshaller(protocolFactory).marshall((CreateBatchPredictionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBatchPredictionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBatchPrediction");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBatchPredictionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBatchPredictionResult createBatchPredictionResult = (CreateBatchPredictionResult)response.getAwsResponse();
            return createBatchPredictionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataSourceFromRDSResult createDataSourceFromRDS(CreateDataSourceFromRDSRequest request) {
        request = (CreateDataSourceFromRDSRequest)this.beforeClientExecution(request);
        return this.executeCreateDataSourceFromRDS(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataSourceFromRDSResult executeCreateDataSourceFromRDS(CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataSourceFromRDSRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataSourceFromRDSRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataSourceFromRDSRequestProtocolMarshaller(protocolFactory).marshall((CreateDataSourceFromRDSRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataSourceFromRDSRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataSourceFromRDS");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceFromRDSResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataSourceFromRDSResult createDataSourceFromRDSResult = (CreateDataSourceFromRDSResult)response.getAwsResponse();
            return createDataSourceFromRDSResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataSourceFromRedshiftResult createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest request) {
        request = (CreateDataSourceFromRedshiftRequest)this.beforeClientExecution(request);
        return this.executeCreateDataSourceFromRedshift(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataSourceFromRedshiftResult executeCreateDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataSourceFromRedshiftRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataSourceFromRedshiftRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataSourceFromRedshiftRequestProtocolMarshaller(protocolFactory).marshall((CreateDataSourceFromRedshiftRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataSourceFromRedshiftRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataSourceFromRedshift");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceFromRedshiftResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataSourceFromRedshiftResult createDataSourceFromRedshiftResult = (CreateDataSourceFromRedshiftResult)response.getAwsResponse();
            return createDataSourceFromRedshiftResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataSourceFromS3Result createDataSourceFromS3(CreateDataSourceFromS3Request request) {
        request = (CreateDataSourceFromS3Request)this.beforeClientExecution(request);
        return this.executeCreateDataSourceFromS3(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataSourceFromS3Result executeCreateDataSourceFromS3(CreateDataSourceFromS3Request createDataSourceFromS3Request) {
        ExecutionContext executionContext = this.createExecutionContext(createDataSourceFromS3Request);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataSourceFromS3Request> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataSourceFromS3RequestProtocolMarshaller(protocolFactory).marshall((CreateDataSourceFromS3Request)super.beforeMarshalling((AmazonWebServiceRequest)createDataSourceFromS3Request));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataSourceFromS3");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSourceFromS3ResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataSourceFromS3Result createDataSourceFromS3Result = (CreateDataSourceFromS3Result)response.getAwsResponse();
            return createDataSourceFromS3Result;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEvaluationResult createEvaluation(CreateEvaluationRequest request) {
        request = (CreateEvaluationRequest)this.beforeClientExecution(request);
        return this.executeCreateEvaluation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEvaluationResult executeCreateEvaluation(CreateEvaluationRequest createEvaluationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEvaluationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEvaluationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEvaluationRequestProtocolMarshaller(protocolFactory).marshall((CreateEvaluationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEvaluationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEvaluation");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEvaluationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEvaluationResult createEvaluationResult = (CreateEvaluationResult)response.getAwsResponse();
            return createEvaluationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMLModelResult createMLModel(CreateMLModelRequest request) {
        request = (CreateMLModelRequest)this.beforeClientExecution(request);
        return this.executeCreateMLModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMLModelResult executeCreateMLModel(CreateMLModelRequest createMLModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMLModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMLModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMLModelRequestProtocolMarshaller(protocolFactory).marshall((CreateMLModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMLModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMLModel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMLModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMLModelResult createMLModelResult = (CreateMLModelResult)response.getAwsResponse();
            return createMLModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRealtimeEndpointResult createRealtimeEndpoint(CreateRealtimeEndpointRequest request) {
        request = (CreateRealtimeEndpointRequest)this.beforeClientExecution(request);
        return this.executeCreateRealtimeEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRealtimeEndpointResult executeCreateRealtimeEndpoint(CreateRealtimeEndpointRequest createRealtimeEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRealtimeEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRealtimeEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRealtimeEndpointRequestProtocolMarshaller(protocolFactory).marshall((CreateRealtimeEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRealtimeEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRealtimeEndpoint");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRealtimeEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRealtimeEndpointResult createRealtimeEndpointResult = (CreateRealtimeEndpointResult)response.getAwsResponse();
            return createRealtimeEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBatchPredictionResult deleteBatchPrediction(DeleteBatchPredictionRequest request) {
        request = (DeleteBatchPredictionRequest)this.beforeClientExecution(request);
        return this.executeDeleteBatchPrediction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBatchPredictionResult executeDeleteBatchPrediction(DeleteBatchPredictionRequest deleteBatchPredictionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBatchPredictionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBatchPredictionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBatchPredictionRequestProtocolMarshaller(protocolFactory).marshall((DeleteBatchPredictionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBatchPredictionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBatchPrediction");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBatchPredictionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBatchPredictionResult deleteBatchPredictionResult = (DeleteBatchPredictionResult)response.getAwsResponse();
            return deleteBatchPredictionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        request = (DeleteDataSourceRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataSourceResult executeDeleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataSourceRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataSource");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataSourceResult deleteDataSourceResult = (DeleteDataSourceResult)response.getAwsResponse();
            return deleteDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEvaluationResult deleteEvaluation(DeleteEvaluationRequest request) {
        request = (DeleteEvaluationRequest)this.beforeClientExecution(request);
        return this.executeDeleteEvaluation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEvaluationResult executeDeleteEvaluation(DeleteEvaluationRequest deleteEvaluationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEvaluationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEvaluationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEvaluationRequestProtocolMarshaller(protocolFactory).marshall((DeleteEvaluationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEvaluationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEvaluation");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEvaluationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEvaluationResult deleteEvaluationResult = (DeleteEvaluationResult)response.getAwsResponse();
            return deleteEvaluationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMLModelResult deleteMLModel(DeleteMLModelRequest request) {
        request = (DeleteMLModelRequest)this.beforeClientExecution(request);
        return this.executeDeleteMLModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMLModelResult executeDeleteMLModel(DeleteMLModelRequest deleteMLModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMLModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMLModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMLModelRequestProtocolMarshaller(protocolFactory).marshall((DeleteMLModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMLModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMLModel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMLModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMLModelResult deleteMLModelResult = (DeleteMLModelResult)response.getAwsResponse();
            return deleteMLModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRealtimeEndpointResult deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest request) {
        request = (DeleteRealtimeEndpointRequest)this.beforeClientExecution(request);
        return this.executeDeleteRealtimeEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRealtimeEndpointResult executeDeleteRealtimeEndpoint(DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRealtimeEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRealtimeEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRealtimeEndpointRequestProtocolMarshaller(protocolFactory).marshall((DeleteRealtimeEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRealtimeEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRealtimeEndpoint");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRealtimeEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRealtimeEndpointResult deleteRealtimeEndpointResult = (DeleteRealtimeEndpointResult)response.getAwsResponse();
            return deleteRealtimeEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest request) {
        request = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executeDeleteTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTagsResult executeDeleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsRequestProtocolMarshaller(protocolFactory).marshall((DeleteTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTags");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsResult deleteTagsResult = (DeleteTagsResult)response.getAwsResponse();
            return deleteTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBatchPredictionsResult describeBatchPredictions(DescribeBatchPredictionsRequest request) {
        request = (DescribeBatchPredictionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeBatchPredictions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBatchPredictionsResult executeDescribeBatchPredictions(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBatchPredictionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBatchPredictionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBatchPredictionsRequestProtocolMarshaller(protocolFactory).marshall((DescribeBatchPredictionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBatchPredictionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBatchPredictions");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBatchPredictionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBatchPredictionsResult describeBatchPredictionsResult = (DescribeBatchPredictionsResult)response.getAwsResponse();
            return describeBatchPredictionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBatchPredictionsResult describeBatchPredictions() {
        return this.describeBatchPredictions(new DescribeBatchPredictionsRequest());
    }

    @Override
    public DescribeDataSourcesResult describeDataSources(DescribeDataSourcesRequest request) {
        request = (DescribeDataSourcesRequest)this.beforeClientExecution(request);
        return this.executeDescribeDataSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDataSourcesResult executeDescribeDataSources(DescribeDataSourcesRequest describeDataSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDataSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDataSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDataSourcesRequestProtocolMarshaller(protocolFactory).marshall((DescribeDataSourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDataSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDataSources");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDataSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDataSourcesResult describeDataSourcesResult = (DescribeDataSourcesResult)response.getAwsResponse();
            return describeDataSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDataSourcesResult describeDataSources() {
        return this.describeDataSources(new DescribeDataSourcesRequest());
    }

    @Override
    public DescribeEvaluationsResult describeEvaluations(DescribeEvaluationsRequest request) {
        request = (DescribeEvaluationsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEvaluations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEvaluationsResult executeDescribeEvaluations(DescribeEvaluationsRequest describeEvaluationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEvaluationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEvaluationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEvaluationsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEvaluationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEvaluationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEvaluations");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEvaluationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEvaluationsResult describeEvaluationsResult = (DescribeEvaluationsResult)response.getAwsResponse();
            return describeEvaluationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEvaluationsResult describeEvaluations() {
        return this.describeEvaluations(new DescribeEvaluationsRequest());
    }

    @Override
    public DescribeMLModelsResult describeMLModels(DescribeMLModelsRequest request) {
        request = (DescribeMLModelsRequest)this.beforeClientExecution(request);
        return this.executeDescribeMLModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMLModelsResult executeDescribeMLModels(DescribeMLModelsRequest describeMLModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMLModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMLModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMLModelsRequestProtocolMarshaller(protocolFactory).marshall((DescribeMLModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeMLModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeMLModels");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMLModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMLModelsResult describeMLModelsResult = (DescribeMLModelsResult)response.getAwsResponse();
            return describeMLModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMLModelsResult describeMLModels() {
        return this.describeMLModels(new DescribeMLModelsRequest());
    }

    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest request) {
        request = (DescribeTagsRequest)this.beforeClientExecution(request);
        return this.executeDescribeTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTagsResult executeDescribeTags(DescribeTagsRequest describeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTagsRequestProtocolMarshaller(protocolFactory).marshall((DescribeTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTags");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTagsResult describeTagsResult = (DescribeTagsResult)response.getAwsResponse();
            return describeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBatchPredictionResult getBatchPrediction(GetBatchPredictionRequest request) {
        request = (GetBatchPredictionRequest)this.beforeClientExecution(request);
        return this.executeGetBatchPrediction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBatchPredictionResult executeGetBatchPrediction(GetBatchPredictionRequest getBatchPredictionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBatchPredictionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBatchPredictionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBatchPredictionRequestProtocolMarshaller(protocolFactory).marshall((GetBatchPredictionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBatchPredictionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBatchPrediction");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBatchPredictionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBatchPredictionResult getBatchPredictionResult = (GetBatchPredictionResult)response.getAwsResponse();
            return getBatchPredictionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        request = (GetDataSourceRequest)this.beforeClientExecution(request);
        return this.executeGetDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataSourceResult executeGetDataSource(GetDataSourceRequest getDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataSourceRequestProtocolMarshaller(protocolFactory).marshall((GetDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataSource");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataSourceResult getDataSourceResult = (GetDataSourceResult)response.getAwsResponse();
            return getDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEvaluationResult getEvaluation(GetEvaluationRequest request) {
        request = (GetEvaluationRequest)this.beforeClientExecution(request);
        return this.executeGetEvaluation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEvaluationResult executeGetEvaluation(GetEvaluationRequest getEvaluationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEvaluationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEvaluationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEvaluationRequestProtocolMarshaller(protocolFactory).marshall((GetEvaluationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEvaluationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEvaluation");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEvaluationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEvaluationResult getEvaluationResult = (GetEvaluationResult)response.getAwsResponse();
            return getEvaluationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMLModelResult getMLModel(GetMLModelRequest request) {
        request = (GetMLModelRequest)this.beforeClientExecution(request);
        return this.executeGetMLModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMLModelResult executeGetMLModel(GetMLModelRequest getMLModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMLModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMLModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMLModelRequestProtocolMarshaller(protocolFactory).marshall((GetMLModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMLModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMLModel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMLModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMLModelResult getMLModelResult = (GetMLModelResult)response.getAwsResponse();
            return getMLModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PredictResult predict(PredictRequest request) {
        request = (PredictRequest)this.beforeClientExecution(request);
        return this.executePredict(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PredictResult executePredict(PredictRequest predictRequest) {
        ExecutionContext executionContext = this.createExecutionContext(predictRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PredictRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PredictRequestProtocolMarshaller(protocolFactory).marshall((PredictRequest)super.beforeMarshalling((AmazonWebServiceRequest)predictRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"Predict");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PredictResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PredictResult predictResult = (PredictResult)response.getAwsResponse();
            return predictResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBatchPredictionResult updateBatchPrediction(UpdateBatchPredictionRequest request) {
        request = (UpdateBatchPredictionRequest)this.beforeClientExecution(request);
        return this.executeUpdateBatchPrediction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBatchPredictionResult executeUpdateBatchPrediction(UpdateBatchPredictionRequest updateBatchPredictionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBatchPredictionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBatchPredictionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBatchPredictionRequestProtocolMarshaller(protocolFactory).marshall((UpdateBatchPredictionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBatchPredictionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBatchPrediction");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBatchPredictionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBatchPredictionResult updateBatchPredictionResult = (UpdateBatchPredictionResult)response.getAwsResponse();
            return updateBatchPredictionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        request = (UpdateDataSourceRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataSourceResult executeUpdateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataSourceRequestProtocolMarshaller(protocolFactory).marshall((UpdateDataSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDataSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataSource");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataSourceResult updateDataSourceResult = (UpdateDataSourceResult)response.getAwsResponse();
            return updateDataSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEvaluationResult updateEvaluation(UpdateEvaluationRequest request) {
        request = (UpdateEvaluationRequest)this.beforeClientExecution(request);
        return this.executeUpdateEvaluation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEvaluationResult executeUpdateEvaluation(UpdateEvaluationRequest updateEvaluationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEvaluationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEvaluationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEvaluationRequestProtocolMarshaller(protocolFactory).marshall((UpdateEvaluationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEvaluationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEvaluation");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEvaluationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEvaluationResult updateEvaluationResult = (UpdateEvaluationResult)response.getAwsResponse();
            return updateEvaluationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateMLModelResult updateMLModel(UpdateMLModelRequest request) {
        request = (UpdateMLModelRequest)this.beforeClientExecution(request);
        return this.executeUpdateMLModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateMLModelResult executeUpdateMLModel(UpdateMLModelRequest updateMLModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateMLModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateMLModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateMLModelRequestProtocolMarshaller(protocolFactory).marshall((UpdateMLModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateMLModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Machine Learning");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateMLModel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateMLModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateMLModelResult updateMLModelResult = (UpdateMLModelResult)response.getAwsResponse();
            return updateMLModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonMachineLearningWaiters waiters() {
        if (this.waiters == null) {
            AmazonMachineLearningClient amazonMachineLearningClient = this;
            synchronized (amazonMachineLearningClient) {
                if (this.waiters == null) {
                    this.waiters = new AmazonMachineLearningWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

