/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.UpdateMLModelRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateMLModelRequestMarshaller
implements Marshaller<Request<UpdateMLModelRequest>, UpdateMLModelRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateMLModelRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateMLModelRequest> marshall(UpdateMLModelRequest updateMLModelRequest) {
        if (updateMLModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateMLModelRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.UpdateMLModel");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateMLModelRequest.getMLModelId() != null) {
                jsonGenerator.writeFieldName("MLModelId").writeValue(updateMLModelRequest.getMLModelId());
            }
            if (updateMLModelRequest.getMLModelName() != null) {
                jsonGenerator.writeFieldName("MLModelName").writeValue(updateMLModelRequest.getMLModelName());
            }
            if (updateMLModelRequest.getScoreThreshold() != null) {
                jsonGenerator.writeFieldName("ScoreThreshold").writeValue(updateMLModelRequest.getScoreThreshold().floatValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

