/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.machinelearning.model.RDSDataSpec;
import com.amazonaws.services.machinelearning.model.transform.RDSDatabaseCredentialsJsonMarshaller;
import com.amazonaws.services.machinelearning.model.transform.RDSDatabaseJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class RDSDataSpecJsonMarshaller {
    private static RDSDataSpecJsonMarshaller instance;

    public void marshall(RDSDataSpec rDSDataSpec, SdkJsonGenerator jsonGenerator) {
        if (rDSDataSpec == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList securityGroupIdsList;
            jsonGenerator.writeStartObject();
            if (rDSDataSpec.getDatabaseInformation() != null) {
                jsonGenerator.writeFieldName("DatabaseInformation");
                RDSDatabaseJsonMarshaller.getInstance().marshall(rDSDataSpec.getDatabaseInformation(), jsonGenerator);
            }
            if (rDSDataSpec.getSelectSqlQuery() != null) {
                jsonGenerator.writeFieldName("SelectSqlQuery").writeValue(rDSDataSpec.getSelectSqlQuery());
            }
            if (rDSDataSpec.getDatabaseCredentials() != null) {
                jsonGenerator.writeFieldName("DatabaseCredentials");
                RDSDatabaseCredentialsJsonMarshaller.getInstance().marshall(rDSDataSpec.getDatabaseCredentials(), jsonGenerator);
            }
            if (rDSDataSpec.getS3StagingLocation() != null) {
                jsonGenerator.writeFieldName("S3StagingLocation").writeValue(rDSDataSpec.getS3StagingLocation());
            }
            if (rDSDataSpec.getDataRearrangement() != null) {
                jsonGenerator.writeFieldName("DataRearrangement").writeValue(rDSDataSpec.getDataRearrangement());
            }
            if (rDSDataSpec.getDataSchema() != null) {
                jsonGenerator.writeFieldName("DataSchema").writeValue(rDSDataSpec.getDataSchema());
            }
            if (rDSDataSpec.getDataSchemaUri() != null) {
                jsonGenerator.writeFieldName("DataSchemaUri").writeValue(rDSDataSpec.getDataSchemaUri());
            }
            if (rDSDataSpec.getResourceRole() != null) {
                jsonGenerator.writeFieldName("ResourceRole").writeValue(rDSDataSpec.getResourceRole());
            }
            if (rDSDataSpec.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(rDSDataSpec.getServiceRole());
            }
            if (rDSDataSpec.getSubnetId() != null) {
                jsonGenerator.writeFieldName("SubnetId").writeValue(rDSDataSpec.getSubnetId());
            }
            if (!(securityGroupIdsList = (SdkInternalList)rDSDataSpec.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RDSDataSpecJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RDSDataSpecJsonMarshaller();
        }
        return instance;
    }
}

