/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.BackTestConfiguration;
import com.amazonaws.services.lookoutmetrics.model.transform.CloudWatchConfigMarshaller;
import java.io.Serializable;

public class CloudWatchConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleArn;
    private BackTestConfiguration backTestConfiguration;

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CloudWatchConfig withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setBackTestConfiguration(BackTestConfiguration backTestConfiguration) {
        this.backTestConfiguration = backTestConfiguration;
    }

    public BackTestConfiguration getBackTestConfiguration() {
        return this.backTestConfiguration;
    }

    public CloudWatchConfig withBackTestConfiguration(BackTestConfiguration backTestConfiguration) {
        this.setBackTestConfiguration(backTestConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getBackTestConfiguration() != null) {
            sb.append("BackTestConfiguration: ").append(this.getBackTestConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchConfig)) {
            return false;
        }
        CloudWatchConfig other = (CloudWatchConfig)obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getBackTestConfiguration() == null ^ this.getBackTestConfiguration() == null) {
            return false;
        }
        return other.getBackTestConfiguration() == null || other.getBackTestConfiguration().equals(this.getBackTestConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getBackTestConfiguration() == null ? 0 : this.getBackTestConfiguration().hashCode());
        return hashCode;
    }

    public CloudWatchConfig clone() {
        try {
            return (CloudWatchConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

