/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutforvision.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutforvision.model.S3Location;
import com.amazonaws.services.lookoutforvision.model.Tag;
import com.amazonaws.services.lookoutforvision.model.TargetDevice;
import com.amazonaws.services.lookoutforvision.model.TargetPlatform;
import com.amazonaws.services.lookoutforvision.model.transform.GreengrassConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GreengrassConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String compilerOptions;
    private String targetDevice;
    private TargetPlatform targetPlatform;
    private S3Location s3OutputLocation;
    private String componentName;
    private String componentVersion;
    private String componentDescription;
    private List<Tag> tags;

    public void setCompilerOptions(String compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public String getCompilerOptions() {
        return this.compilerOptions;
    }

    public GreengrassConfiguration withCompilerOptions(String compilerOptions) {
        this.setCompilerOptions(compilerOptions);
        return this;
    }

    public void setTargetDevice(String targetDevice) {
        this.targetDevice = targetDevice;
    }

    public String getTargetDevice() {
        return this.targetDevice;
    }

    public GreengrassConfiguration withTargetDevice(String targetDevice) {
        this.setTargetDevice(targetDevice);
        return this;
    }

    public GreengrassConfiguration withTargetDevice(TargetDevice targetDevice) {
        this.targetDevice = targetDevice.toString();
        return this;
    }

    public void setTargetPlatform(TargetPlatform targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public GreengrassConfiguration withTargetPlatform(TargetPlatform targetPlatform) {
        this.setTargetPlatform(targetPlatform);
        return this;
    }

    public void setS3OutputLocation(S3Location s3OutputLocation) {
        this.s3OutputLocation = s3OutputLocation;
    }

    public S3Location getS3OutputLocation() {
        return this.s3OutputLocation;
    }

    public GreengrassConfiguration withS3OutputLocation(S3Location s3OutputLocation) {
        this.setS3OutputLocation(s3OutputLocation);
        return this;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public GreengrassConfiguration withComponentName(String componentName) {
        this.setComponentName(componentName);
        return this;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public GreengrassConfiguration withComponentVersion(String componentVersion) {
        this.setComponentVersion(componentVersion);
        return this;
    }

    public void setComponentDescription(String componentDescription) {
        this.componentDescription = componentDescription;
    }

    public String getComponentDescription() {
        return this.componentDescription;
    }

    public GreengrassConfiguration withComponentDescription(String componentDescription) {
        this.setComponentDescription(componentDescription);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public GreengrassConfiguration withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public GreengrassConfiguration withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCompilerOptions() != null) {
            sb.append("CompilerOptions: ").append(this.getCompilerOptions()).append(",");
        }
        if (this.getTargetDevice() != null) {
            sb.append("TargetDevice: ").append(this.getTargetDevice()).append(",");
        }
        if (this.getTargetPlatform() != null) {
            sb.append("TargetPlatform: ").append(this.getTargetPlatform()).append(",");
        }
        if (this.getS3OutputLocation() != null) {
            sb.append("S3OutputLocation: ").append(this.getS3OutputLocation()).append(",");
        }
        if (this.getComponentName() != null) {
            sb.append("ComponentName: ").append(this.getComponentName()).append(",");
        }
        if (this.getComponentVersion() != null) {
            sb.append("ComponentVersion: ").append(this.getComponentVersion()).append(",");
        }
        if (this.getComponentDescription() != null) {
            sb.append("ComponentDescription: ").append(this.getComponentDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GreengrassConfiguration)) {
            return false;
        }
        GreengrassConfiguration other = (GreengrassConfiguration)obj;
        if (other.getCompilerOptions() == null ^ this.getCompilerOptions() == null) {
            return false;
        }
        if (other.getCompilerOptions() != null && !other.getCompilerOptions().equals(this.getCompilerOptions())) {
            return false;
        }
        if (other.getTargetDevice() == null ^ this.getTargetDevice() == null) {
            return false;
        }
        if (other.getTargetDevice() != null && !other.getTargetDevice().equals(this.getTargetDevice())) {
            return false;
        }
        if (other.getTargetPlatform() == null ^ this.getTargetPlatform() == null) {
            return false;
        }
        if (other.getTargetPlatform() != null && !other.getTargetPlatform().equals(this.getTargetPlatform())) {
            return false;
        }
        if (other.getS3OutputLocation() == null ^ this.getS3OutputLocation() == null) {
            return false;
        }
        if (other.getS3OutputLocation() != null && !other.getS3OutputLocation().equals(this.getS3OutputLocation())) {
            return false;
        }
        if (other.getComponentName() == null ^ this.getComponentName() == null) {
            return false;
        }
        if (other.getComponentName() != null && !other.getComponentName().equals(this.getComponentName())) {
            return false;
        }
        if (other.getComponentVersion() == null ^ this.getComponentVersion() == null) {
            return false;
        }
        if (other.getComponentVersion() != null && !other.getComponentVersion().equals(this.getComponentVersion())) {
            return false;
        }
        if (other.getComponentDescription() == null ^ this.getComponentDescription() == null) {
            return false;
        }
        if (other.getComponentDescription() != null && !other.getComponentDescription().equals(this.getComponentDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCompilerOptions() == null ? 0 : this.getCompilerOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDevice() == null ? 0 : this.getTargetDevice().hashCode());
        hashCode = 31 * hashCode + (this.getTargetPlatform() == null ? 0 : this.getTargetPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getS3OutputLocation() == null ? 0 : this.getS3OutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getComponentName() == null ? 0 : this.getComponentName().hashCode());
        hashCode = 31 * hashCode + (this.getComponentVersion() == null ? 0 : this.getComponentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getComponentDescription() == null ? 0 : this.getComponentDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public GreengrassConfiguration clone() {
        try {
            return (GreengrassConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GreengrassConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

