/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutforvision.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutforvision.model.TargetPlatform;

@SdkInternalApi
public class TargetPlatformMarshaller {
    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").build();
    private static final MarshallingInfo<String> ARCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arch").build();
    private static final MarshallingInfo<String> ACCELERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Accelerator").build();
    private static final TargetPlatformMarshaller instance = new TargetPlatformMarshaller();

    public static TargetPlatformMarshaller getInstance() {
        return instance;
    }

    public void marshall(TargetPlatform targetPlatform, ProtocolMarshaller protocolMarshaller) {
        if (targetPlatform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)targetPlatform.getOs(), OS_BINDING);
            protocolMarshaller.marshall((Object)targetPlatform.getArch(), ARCH_BINDING);
            protocolMarshaller.marshall((Object)targetPlatform.getAccelerator(), ACCELERATOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

