/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lookoutequipment.model.ModelVersionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListModelVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ModelVersionSummary> modelVersionSummaries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListModelVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ModelVersionSummary> getModelVersionSummaries() {
        return this.modelVersionSummaries;
    }

    public void setModelVersionSummaries(Collection<ModelVersionSummary> modelVersionSummaries) {
        if (modelVersionSummaries == null) {
            this.modelVersionSummaries = null;
            return;
        }
        this.modelVersionSummaries = new ArrayList<ModelVersionSummary>(modelVersionSummaries);
    }

    public ListModelVersionsResult withModelVersionSummaries(ModelVersionSummary ... modelVersionSummaries) {
        if (this.modelVersionSummaries == null) {
            this.setModelVersionSummaries(new ArrayList<ModelVersionSummary>(modelVersionSummaries.length));
        }
        for (ModelVersionSummary ele : modelVersionSummaries) {
            this.modelVersionSummaries.add(ele);
        }
        return this;
    }

    public ListModelVersionsResult withModelVersionSummaries(Collection<ModelVersionSummary> modelVersionSummaries) {
        this.setModelVersionSummaries(modelVersionSummaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getModelVersionSummaries() != null) {
            sb.append("ModelVersionSummaries: ").append(this.getModelVersionSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelVersionsResult)) {
            return false;
        }
        ListModelVersionsResult other = (ListModelVersionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getModelVersionSummaries() == null ^ this.getModelVersionSummaries() == null) {
            return false;
        }
        return other.getModelVersionSummaries() == null || other.getModelVersionSummaries().equals(this.getModelVersionSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getModelVersionSummaries() == null ? 0 : this.getModelVersionSummaries().hashCode());
        return hashCode;
    }

    public ListModelVersionsResult clone() {
        try {
            return (ListModelVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

