/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.LightsailDistribution;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetDistributionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<LightsailDistribution> distributions;
    private String nextPageToken;

    public List<LightsailDistribution> getDistributions() {
        return this.distributions;
    }

    public void setDistributions(Collection<LightsailDistribution> distributions) {
        if (distributions == null) {
            this.distributions = null;
            return;
        }
        this.distributions = new ArrayList<LightsailDistribution>(distributions);
    }

    public GetDistributionsResult withDistributions(LightsailDistribution ... distributions) {
        if (this.distributions == null) {
            this.setDistributions(new ArrayList<LightsailDistribution>(distributions.length));
        }
        for (LightsailDistribution ele : distributions) {
            this.distributions.add(ele);
        }
        return this;
    }

    public GetDistributionsResult withDistributions(Collection<LightsailDistribution> distributions) {
        this.setDistributions(distributions);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetDistributionsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDistributions() != null) {
            sb.append("Distributions: ").append(this.getDistributions()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionsResult)) {
            return false;
        }
        GetDistributionsResult other = (GetDistributionsResult)obj;
        if (other.getDistributions() == null ^ this.getDistributions() == null) {
            return false;
        }
        if (other.getDistributions() != null && !other.getDistributions().equals(this.getDistributions())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDistributions() == null ? 0 : this.getDistributions().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetDistributionsResult clone() {
        try {
            return (GetDistributionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

