/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lightsail.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes a request to configure an Amazon Lightsail container service to access private container image
 * repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access"
 * >Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the
 * <i>Amazon Lightsail Developer Guide</i>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PrivateRegistryAccessRequest"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PrivateRegistryAccessRequest implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail
     * container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     * </p>
     */
    private ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole;

    /**
     * <p>
     * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail
     * container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     * </p>
     * 
     * @param ecrImagePullerRole
     *        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
     *        Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     */

    public void setEcrImagePullerRole(ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole) {
        this.ecrImagePullerRole = ecrImagePullerRole;
    }

    /**
     * <p>
     * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail
     * container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     * </p>
     * 
     * @return An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
     *         Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private
     *         repositories.
     */

    public ContainerServiceECRImagePullerRoleRequest getEcrImagePullerRole() {
        return this.ecrImagePullerRole;
    }

    /**
     * <p>
     * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail
     * container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     * </p>
     * 
     * @param ecrImagePullerRole
     *        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
     *        Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PrivateRegistryAccessRequest withEcrImagePullerRole(ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole) {
        setEcrImagePullerRole(ecrImagePullerRole);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEcrImagePullerRole() != null)
            sb.append("EcrImagePullerRole: ").append(getEcrImagePullerRole());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PrivateRegistryAccessRequest == false)
            return false;
        PrivateRegistryAccessRequest other = (PrivateRegistryAccessRequest) obj;
        if (other.getEcrImagePullerRole() == null ^ this.getEcrImagePullerRole() == null)
            return false;
        if (other.getEcrImagePullerRole() != null && other.getEcrImagePullerRole().equals(this.getEcrImagePullerRole()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEcrImagePullerRole() == null) ? 0 : getEcrImagePullerRole().hashCode());
        return hashCode;
    }

    @Override
    public PrivateRegistryAccessRequest clone() {
        try {
            return (PrivateRegistryAccessRequest) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lightsail.model.transform.PrivateRegistryAccessRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
