/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CertificateStatus;
import com.amazonaws.services.lightsail.model.DomainValidationRecord;
import com.amazonaws.services.lightsail.model.RenewalSummary;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.transform.CertificateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Certificate
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String domainName;
    private String status;
    private String serialNumber;
    private List<String> subjectAlternativeNames;
    private List<DomainValidationRecord> domainValidationRecords;
    private String requestFailureReason;
    private Integer inUseResourceCount;
    private String keyAlgorithm;
    private Date createdAt;
    private Date issuedAt;
    private String issuerCA;
    private Date notBefore;
    private Date notAfter;
    private String eligibleToRenew;
    private RenewalSummary renewalSummary;
    private Date revokedAt;
    private String revocationReason;
    private List<Tag> tags;
    private String supportCode;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Certificate withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Certificate withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Certificate withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Certificate withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Certificate withStatus(CertificateStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Certificate withSerialNumber(String serialNumber) {
        this.setSerialNumber(serialNumber);
        return this;
    }

    public List<String> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
        if (subjectAlternativeNames == null) {
            this.subjectAlternativeNames = null;
            return;
        }
        this.subjectAlternativeNames = new ArrayList<String>(subjectAlternativeNames);
    }

    public Certificate withSubjectAlternativeNames(String ... subjectAlternativeNames) {
        if (this.subjectAlternativeNames == null) {
            this.setSubjectAlternativeNames(new ArrayList<String>(subjectAlternativeNames.length));
        }
        for (String ele : subjectAlternativeNames) {
            this.subjectAlternativeNames.add(ele);
        }
        return this;
    }

    public Certificate withSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
        this.setSubjectAlternativeNames(subjectAlternativeNames);
        return this;
    }

    public List<DomainValidationRecord> getDomainValidationRecords() {
        return this.domainValidationRecords;
    }

    public void setDomainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
        if (domainValidationRecords == null) {
            this.domainValidationRecords = null;
            return;
        }
        this.domainValidationRecords = new ArrayList<DomainValidationRecord>(domainValidationRecords);
    }

    public Certificate withDomainValidationRecords(DomainValidationRecord ... domainValidationRecords) {
        if (this.domainValidationRecords == null) {
            this.setDomainValidationRecords(new ArrayList<DomainValidationRecord>(domainValidationRecords.length));
        }
        for (DomainValidationRecord ele : domainValidationRecords) {
            this.domainValidationRecords.add(ele);
        }
        return this;
    }

    public Certificate withDomainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
        this.setDomainValidationRecords(domainValidationRecords);
        return this;
    }

    public void setRequestFailureReason(String requestFailureReason) {
        this.requestFailureReason = requestFailureReason;
    }

    public String getRequestFailureReason() {
        return this.requestFailureReason;
    }

    public Certificate withRequestFailureReason(String requestFailureReason) {
        this.setRequestFailureReason(requestFailureReason);
        return this;
    }

    public void setInUseResourceCount(Integer inUseResourceCount) {
        this.inUseResourceCount = inUseResourceCount;
    }

    public Integer getInUseResourceCount() {
        return this.inUseResourceCount;
    }

    public Certificate withInUseResourceCount(Integer inUseResourceCount) {
        this.setInUseResourceCount(inUseResourceCount);
        return this;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public Certificate withKeyAlgorithm(String keyAlgorithm) {
        this.setKeyAlgorithm(keyAlgorithm);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Certificate withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public Certificate withIssuedAt(Date issuedAt) {
        this.setIssuedAt(issuedAt);
        return this;
    }

    public void setIssuerCA(String issuerCA) {
        this.issuerCA = issuerCA;
    }

    public String getIssuerCA() {
        return this.issuerCA;
    }

    public Certificate withIssuerCA(String issuerCA) {
        this.setIssuerCA(issuerCA);
        return this;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Certificate withNotBefore(Date notBefore) {
        this.setNotBefore(notBefore);
        return this;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public Certificate withNotAfter(Date notAfter) {
        this.setNotAfter(notAfter);
        return this;
    }

    public void setEligibleToRenew(String eligibleToRenew) {
        this.eligibleToRenew = eligibleToRenew;
    }

    public String getEligibleToRenew() {
        return this.eligibleToRenew;
    }

    public Certificate withEligibleToRenew(String eligibleToRenew) {
        this.setEligibleToRenew(eligibleToRenew);
        return this;
    }

    public void setRenewalSummary(RenewalSummary renewalSummary) {
        this.renewalSummary = renewalSummary;
    }

    public RenewalSummary getRenewalSummary() {
        return this.renewalSummary;
    }

    public Certificate withRenewalSummary(RenewalSummary renewalSummary) {
        this.setRenewalSummary(renewalSummary);
        return this;
    }

    public void setRevokedAt(Date revokedAt) {
        this.revokedAt = revokedAt;
    }

    public Date getRevokedAt() {
        return this.revokedAt;
    }

    public Certificate withRevokedAt(Date revokedAt) {
        this.setRevokedAt(revokedAt);
        return this;
    }

    public void setRevocationReason(String revocationReason) {
        this.revocationReason = revocationReason;
    }

    public String getRevocationReason() {
        return this.revocationReason;
    }

    public Certificate withRevocationReason(String revocationReason) {
        this.setRevocationReason(revocationReason);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Certificate withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Certificate withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public Certificate withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getSerialNumber() != null) {
            sb.append("SerialNumber: ").append(this.getSerialNumber()).append(",");
        }
        if (this.getSubjectAlternativeNames() != null) {
            sb.append("SubjectAlternativeNames: ").append(this.getSubjectAlternativeNames()).append(",");
        }
        if (this.getDomainValidationRecords() != null) {
            sb.append("DomainValidationRecords: ").append(this.getDomainValidationRecords()).append(",");
        }
        if (this.getRequestFailureReason() != null) {
            sb.append("RequestFailureReason: ").append(this.getRequestFailureReason()).append(",");
        }
        if (this.getInUseResourceCount() != null) {
            sb.append("InUseResourceCount: ").append(this.getInUseResourceCount()).append(",");
        }
        if (this.getKeyAlgorithm() != null) {
            sb.append("KeyAlgorithm: ").append(this.getKeyAlgorithm()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getIssuedAt() != null) {
            sb.append("IssuedAt: ").append(this.getIssuedAt()).append(",");
        }
        if (this.getIssuerCA() != null) {
            sb.append("IssuerCA: ").append(this.getIssuerCA()).append(",");
        }
        if (this.getNotBefore() != null) {
            sb.append("NotBefore: ").append(this.getNotBefore()).append(",");
        }
        if (this.getNotAfter() != null) {
            sb.append("NotAfter: ").append(this.getNotAfter()).append(",");
        }
        if (this.getEligibleToRenew() != null) {
            sb.append("EligibleToRenew: ").append(this.getEligibleToRenew()).append(",");
        }
        if (this.getRenewalSummary() != null) {
            sb.append("RenewalSummary: ").append(this.getRenewalSummary()).append(",");
        }
        if (this.getRevokedAt() != null) {
            sb.append("RevokedAt: ").append(this.getRevokedAt()).append(",");
        }
        if (this.getRevocationReason() != null) {
            sb.append("RevocationReason: ").append(this.getRevocationReason()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSerialNumber() == null ^ this.getSerialNumber() == null) {
            return false;
        }
        if (other.getSerialNumber() != null && !other.getSerialNumber().equals(this.getSerialNumber())) {
            return false;
        }
        if (other.getSubjectAlternativeNames() == null ^ this.getSubjectAlternativeNames() == null) {
            return false;
        }
        if (other.getSubjectAlternativeNames() != null && !other.getSubjectAlternativeNames().equals(this.getSubjectAlternativeNames())) {
            return false;
        }
        if (other.getDomainValidationRecords() == null ^ this.getDomainValidationRecords() == null) {
            return false;
        }
        if (other.getDomainValidationRecords() != null && !other.getDomainValidationRecords().equals(this.getDomainValidationRecords())) {
            return false;
        }
        if (other.getRequestFailureReason() == null ^ this.getRequestFailureReason() == null) {
            return false;
        }
        if (other.getRequestFailureReason() != null && !other.getRequestFailureReason().equals(this.getRequestFailureReason())) {
            return false;
        }
        if (other.getInUseResourceCount() == null ^ this.getInUseResourceCount() == null) {
            return false;
        }
        if (other.getInUseResourceCount() != null && !other.getInUseResourceCount().equals(this.getInUseResourceCount())) {
            return false;
        }
        if (other.getKeyAlgorithm() == null ^ this.getKeyAlgorithm() == null) {
            return false;
        }
        if (other.getKeyAlgorithm() != null && !other.getKeyAlgorithm().equals(this.getKeyAlgorithm())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getIssuedAt() == null ^ this.getIssuedAt() == null) {
            return false;
        }
        if (other.getIssuedAt() != null && !other.getIssuedAt().equals(this.getIssuedAt())) {
            return false;
        }
        if (other.getIssuerCA() == null ^ this.getIssuerCA() == null) {
            return false;
        }
        if (other.getIssuerCA() != null && !other.getIssuerCA().equals(this.getIssuerCA())) {
            return false;
        }
        if (other.getNotBefore() == null ^ this.getNotBefore() == null) {
            return false;
        }
        if (other.getNotBefore() != null && !other.getNotBefore().equals(this.getNotBefore())) {
            return false;
        }
        if (other.getNotAfter() == null ^ this.getNotAfter() == null) {
            return false;
        }
        if (other.getNotAfter() != null && !other.getNotAfter().equals(this.getNotAfter())) {
            return false;
        }
        if (other.getEligibleToRenew() == null ^ this.getEligibleToRenew() == null) {
            return false;
        }
        if (other.getEligibleToRenew() != null && !other.getEligibleToRenew().equals(this.getEligibleToRenew())) {
            return false;
        }
        if (other.getRenewalSummary() == null ^ this.getRenewalSummary() == null) {
            return false;
        }
        if (other.getRenewalSummary() != null && !other.getRenewalSummary().equals(this.getRenewalSummary())) {
            return false;
        }
        if (other.getRevokedAt() == null ^ this.getRevokedAt() == null) {
            return false;
        }
        if (other.getRevokedAt() != null && !other.getRevokedAt().equals(this.getRevokedAt())) {
            return false;
        }
        if (other.getRevocationReason() == null ^ this.getRevocationReason() == null) {
            return false;
        }
        if (other.getRevocationReason() != null && !other.getRevocationReason().equals(this.getRevocationReason())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        return other.getSupportCode() == null || other.getSupportCode().equals(this.getSupportCode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSerialNumber() == null ? 0 : this.getSerialNumber().hashCode());
        hashCode = 31 * hashCode + (this.getSubjectAlternativeNames() == null ? 0 : this.getSubjectAlternativeNames().hashCode());
        hashCode = 31 * hashCode + (this.getDomainValidationRecords() == null ? 0 : this.getDomainValidationRecords().hashCode());
        hashCode = 31 * hashCode + (this.getRequestFailureReason() == null ? 0 : this.getRequestFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getInUseResourceCount() == null ? 0 : this.getInUseResourceCount().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAlgorithm() == null ? 0 : this.getKeyAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getIssuedAt() == null ? 0 : this.getIssuedAt().hashCode());
        hashCode = 31 * hashCode + (this.getIssuerCA() == null ? 0 : this.getIssuerCA().hashCode());
        hashCode = 31 * hashCode + (this.getNotBefore() == null ? 0 : this.getNotBefore().hashCode());
        hashCode = 31 * hashCode + (this.getNotAfter() == null ? 0 : this.getNotAfter().hashCode());
        hashCode = 31 * hashCode + (this.getEligibleToRenew() == null ? 0 : this.getEligibleToRenew().hashCode());
        hashCode = 31 * hashCode + (this.getRenewalSummary() == null ? 0 : this.getRenewalSummary().hashCode());
        hashCode = 31 * hashCode + (this.getRevokedAt() == null ? 0 : this.getRevokedAt().hashCode());
        hashCode = 31 * hashCode + (this.getRevocationReason() == null ? 0 : this.getRevocationReason().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        return hashCode;
    }

    public Certificate clone() {
        try {
            return (Certificate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

