/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.CookieObject;
import java.util.List;

@SdkInternalApi
public class CookieObjectMarshaller {
    private static final MarshallingInfo<String> OPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("option").build();
    private static final MarshallingInfo<List> COOKIESALLOWLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cookiesAllowList").build();
    private static final CookieObjectMarshaller instance = new CookieObjectMarshaller();

    public static CookieObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(CookieObject cookieObject, ProtocolMarshaller protocolMarshaller) {
        if (cookieObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cookieObject.getOption(), OPTION_BINDING);
            protocolMarshaller.marshall(cookieObject.getCookiesAllowList(), COOKIESALLOWLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

