/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.GetBundlesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetBundlesRequestMarshaller
implements Marshaller<Request<GetBundlesRequest>, GetBundlesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetBundlesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetBundlesRequest> marshall(GetBundlesRequest getBundlesRequest) {
        if (getBundlesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBundlesRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.GetBundles");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getBundlesRequest.getIncludeInactive() != null) {
                jsonGenerator.writeFieldName("includeInactive").writeValue(getBundlesRequest.getIncludeInactive().booleanValue());
            }
            if (getBundlesRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("pageToken").writeValue(getBundlesRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

