/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.ResourceLocation;

public class ResourceLocationJsonMarshaller {
    private static ResourceLocationJsonMarshaller instance;

    public void marshall(ResourceLocation resourceLocation, StructuredJsonGenerator jsonGenerator) {
        if (resourceLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (resourceLocation.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("availabilityZone").writeValue(resourceLocation.getAvailabilityZone());
            }
            if (resourceLocation.getRegionName() != null) {
                jsonGenerator.writeFieldName("regionName").writeValue(resourceLocation.getRegionName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ResourceLocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceLocationJsonMarshaller();
        }
        return instance;
    }
}

