/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Instance> instances;
    private String nextPageToken;

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<Instance>(instances);
    }

    public GetInstancesResult withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public GetInstancesResult withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetInstancesResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesResult)) {
            return false;
        }
        GetInstancesResult other = (GetInstancesResult)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public GetInstancesResult clone() {
        try {
            return (GetInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

