/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.ImportKeyPairRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ImportKeyPairRequestMarshaller
implements Marshaller<Request<ImportKeyPairRequest>, ImportKeyPairRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ImportKeyPairRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ImportKeyPairRequest> marshall(ImportKeyPairRequest importKeyPairRequest) {
        if (importKeyPairRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importKeyPairRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.ImportKeyPair");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (importKeyPairRequest.getKeyPairName() != null) {
                jsonGenerator.writeFieldName("keyPairName").writeValue(importKeyPairRequest.getKeyPairName());
            }
            if (importKeyPairRequest.getPublicKeyBase64() != null) {
                jsonGenerator.writeFieldName("publicKeyBase64").writeValue(importKeyPairRequest.getPublicKeyBase64());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

