/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.AllowedOperation;
import com.amazonaws.services.licensemanager.model.ReceivedStatus;
import com.amazonaws.services.licensemanager.model.transform.ReceivedMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReceivedMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String receivedStatus;
    private List<String> allowedOperations;

    public void setReceivedStatus(String receivedStatus) {
        this.receivedStatus = receivedStatus;
    }

    public String getReceivedStatus() {
        return this.receivedStatus;
    }

    public ReceivedMetadata withReceivedStatus(String receivedStatus) {
        this.setReceivedStatus(receivedStatus);
        return this;
    }

    public ReceivedMetadata withReceivedStatus(ReceivedStatus receivedStatus) {
        this.receivedStatus = receivedStatus.toString();
        return this;
    }

    public List<String> getAllowedOperations() {
        return this.allowedOperations;
    }

    public void setAllowedOperations(Collection<String> allowedOperations) {
        if (allowedOperations == null) {
            this.allowedOperations = null;
            return;
        }
        this.allowedOperations = new ArrayList<String>(allowedOperations);
    }

    public ReceivedMetadata withAllowedOperations(String ... allowedOperations) {
        if (this.allowedOperations == null) {
            this.setAllowedOperations(new ArrayList<String>(allowedOperations.length));
        }
        for (String ele : allowedOperations) {
            this.allowedOperations.add(ele);
        }
        return this;
    }

    public ReceivedMetadata withAllowedOperations(Collection<String> allowedOperations) {
        this.setAllowedOperations(allowedOperations);
        return this;
    }

    public ReceivedMetadata withAllowedOperations(AllowedOperation ... allowedOperations) {
        ArrayList<String> allowedOperationsCopy = new ArrayList<String>(allowedOperations.length);
        for (AllowedOperation value : allowedOperations) {
            allowedOperationsCopy.add(value.toString());
        }
        if (this.getAllowedOperations() == null) {
            this.setAllowedOperations(allowedOperationsCopy);
        } else {
            this.getAllowedOperations().addAll(allowedOperationsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReceivedStatus() != null) {
            sb.append("ReceivedStatus: ").append(this.getReceivedStatus()).append(",");
        }
        if (this.getAllowedOperations() != null) {
            sb.append("AllowedOperations: ").append(this.getAllowedOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceivedMetadata)) {
            return false;
        }
        ReceivedMetadata other = (ReceivedMetadata)obj;
        if (other.getReceivedStatus() == null ^ this.getReceivedStatus() == null) {
            return false;
        }
        if (other.getReceivedStatus() != null && !other.getReceivedStatus().equals(this.getReceivedStatus())) {
            return false;
        }
        if (other.getAllowedOperations() == null ^ this.getAllowedOperations() == null) {
            return false;
        }
        return other.getAllowedOperations() == null || other.getAllowedOperations().equals(this.getAllowedOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReceivedStatus() == null ? 0 : this.getReceivedStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedOperations() == null ? 0 : this.getAllowedOperations().hashCode());
        return hashCode;
    }

    public ReceivedMetadata clone() {
        try {
            return (ReceivedMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReceivedMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

