/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelsv2.model.ActiveContext;
import com.amazonaws.services.lexmodelsv2.model.UserTurnIntentOutput;
import com.amazonaws.services.lexmodelsv2.model.transform.UserTurnOutputSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserTurnOutputSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private UserTurnIntentOutput intent;
    private List<ActiveContext> activeContexts;
    private String transcript;

    public void setIntent(UserTurnIntentOutput intent) {
        this.intent = intent;
    }

    public UserTurnIntentOutput getIntent() {
        return this.intent;
    }

    public UserTurnOutputSpecification withIntent(UserTurnIntentOutput intent) {
        this.setIntent(intent);
        return this;
    }

    public List<ActiveContext> getActiveContexts() {
        return this.activeContexts;
    }

    public void setActiveContexts(Collection<ActiveContext> activeContexts) {
        if (activeContexts == null) {
            this.activeContexts = null;
            return;
        }
        this.activeContexts = new ArrayList<ActiveContext>(activeContexts);
    }

    public UserTurnOutputSpecification withActiveContexts(ActiveContext ... activeContexts) {
        if (this.activeContexts == null) {
            this.setActiveContexts(new ArrayList<ActiveContext>(activeContexts.length));
        }
        for (ActiveContext ele : activeContexts) {
            this.activeContexts.add(ele);
        }
        return this;
    }

    public UserTurnOutputSpecification withActiveContexts(Collection<ActiveContext> activeContexts) {
        this.setActiveContexts(activeContexts);
        return this;
    }

    public void setTranscript(String transcript) {
        this.transcript = transcript;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public UserTurnOutputSpecification withTranscript(String transcript) {
        this.setTranscript(transcript);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntent() != null) {
            sb.append("Intent: ").append(this.getIntent()).append(",");
        }
        if (this.getActiveContexts() != null) {
            sb.append("ActiveContexts: ").append(this.getActiveContexts()).append(",");
        }
        if (this.getTranscript() != null) {
            sb.append("Transcript: ").append(this.getTranscript());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnOutputSpecification)) {
            return false;
        }
        UserTurnOutputSpecification other = (UserTurnOutputSpecification)obj;
        if (other.getIntent() == null ^ this.getIntent() == null) {
            return false;
        }
        if (other.getIntent() != null && !other.getIntent().equals(this.getIntent())) {
            return false;
        }
        if (other.getActiveContexts() == null ^ this.getActiveContexts() == null) {
            return false;
        }
        if (other.getActiveContexts() != null && !other.getActiveContexts().equals(this.getActiveContexts())) {
            return false;
        }
        if (other.getTranscript() == null ^ this.getTranscript() == null) {
            return false;
        }
        return other.getTranscript() == null || other.getTranscript().equals(this.getTranscript());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntent() == null ? 0 : this.getIntent().hashCode());
        hashCode = 31 * hashCode + (this.getActiveContexts() == null ? 0 : this.getActiveContexts().hashCode());
        hashCode = 31 * hashCode + (this.getTranscript() == null ? 0 : this.getTranscript().hashCode());
        return hashCode;
    }

    public UserTurnOutputSpecification clone() {
        try {
            return (UserTurnOutputSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserTurnOutputSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

