/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelsv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lexmodelsv2.model.ExportResourceSpecification;
import com.amazonaws.services.lexmodelsv2.model.ImportExportFileFormat;
import java.io.Serializable;

public class CreateExportRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ExportResourceSpecification resourceSpecification;
    private String fileFormat;
    private String filePassword;

    public void setResourceSpecification(ExportResourceSpecification resourceSpecification) {
        this.resourceSpecification = resourceSpecification;
    }

    public ExportResourceSpecification getResourceSpecification() {
        return this.resourceSpecification;
    }

    public CreateExportRequest withResourceSpecification(ExportResourceSpecification resourceSpecification) {
        this.setResourceSpecification(resourceSpecification);
        return this;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public CreateExportRequest withFileFormat(String fileFormat) {
        this.setFileFormat(fileFormat);
        return this;
    }

    public CreateExportRequest withFileFormat(ImportExportFileFormat fileFormat) {
        this.fileFormat = fileFormat.toString();
        return this;
    }

    public void setFilePassword(String filePassword) {
        this.filePassword = filePassword;
    }

    public String getFilePassword() {
        return this.filePassword;
    }

    public CreateExportRequest withFilePassword(String filePassword) {
        this.setFilePassword(filePassword);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSpecification() != null) {
            sb.append("ResourceSpecification: ").append(this.getResourceSpecification()).append(",");
        }
        if (this.getFileFormat() != null) {
            sb.append("FileFormat: ").append(this.getFileFormat()).append(",");
        }
        if (this.getFilePassword() != null) {
            sb.append("FilePassword: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportRequest)) {
            return false;
        }
        CreateExportRequest other = (CreateExportRequest)obj;
        if (other.getResourceSpecification() == null ^ this.getResourceSpecification() == null) {
            return false;
        }
        if (other.getResourceSpecification() != null && !other.getResourceSpecification().equals(this.getResourceSpecification())) {
            return false;
        }
        if (other.getFileFormat() == null ^ this.getFileFormat() == null) {
            return false;
        }
        if (other.getFileFormat() != null && !other.getFileFormat().equals(this.getFileFormat())) {
            return false;
        }
        if (other.getFilePassword() == null ^ this.getFilePassword() == null) {
            return false;
        }
        return other.getFilePassword() == null || other.getFilePassword().equals(this.getFilePassword());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSpecification() == null ? 0 : this.getResourceSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getFileFormat() == null ? 0 : this.getFileFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFilePassword() == null ? 0 : this.getFilePassword().hashCode());
        return hashCode;
    }

    public CreateExportRequest clone() {
        return (CreateExportRequest)super.clone();
    }
}

