/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.transform.DeleteObjectInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteObjectInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String uri;
    private String eTag;
    private List<String> partitionValues;

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public DeleteObjectInput withUri(String uri) {
        this.setUri(uri);
        return this;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }

    public DeleteObjectInput withETag(String eTag) {
        this.setETag(eTag);
        return this;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public void setPartitionValues(Collection<String> partitionValues) {
        if (partitionValues == null) {
            this.partitionValues = null;
            return;
        }
        this.partitionValues = new ArrayList<String>(partitionValues);
    }

    public DeleteObjectInput withPartitionValues(String ... partitionValues) {
        if (this.partitionValues == null) {
            this.setPartitionValues(new ArrayList<String>(partitionValues.length));
        }
        for (String ele : partitionValues) {
            this.partitionValues.add(ele);
        }
        return this;
    }

    public DeleteObjectInput withPartitionValues(Collection<String> partitionValues) {
        this.setPartitionValues(partitionValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUri() != null) {
            sb.append("Uri: ").append(this.getUri()).append(",");
        }
        if (this.getETag() != null) {
            sb.append("ETag: ").append(this.getETag()).append(",");
        }
        if (this.getPartitionValues() != null) {
            sb.append("PartitionValues: ").append(this.getPartitionValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectInput)) {
            return false;
        }
        DeleteObjectInput other = (DeleteObjectInput)obj;
        if (other.getUri() == null ^ this.getUri() == null) {
            return false;
        }
        if (other.getUri() != null && !other.getUri().equals(this.getUri())) {
            return false;
        }
        if (other.getETag() == null ^ this.getETag() == null) {
            return false;
        }
        if (other.getETag() != null && !other.getETag().equals(this.getETag())) {
            return false;
        }
        if (other.getPartitionValues() == null ^ this.getPartitionValues() == null) {
            return false;
        }
        return other.getPartitionValues() == null || other.getPartitionValues().equals(this.getPartitionValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUri() == null ? 0 : this.getUri().hashCode());
        hashCode = 31 * hashCode + (this.getETag() == null ? 0 : this.getETag().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionValues() == null ? 0 : this.getPartitionValues().hashCode());
        return hashCode;
    }

    public DeleteObjectInput clone() {
        try {
            return (DeleteObjectInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeleteObjectInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

