/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.transform.LFTagPairMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LFTagPair
implements Serializable,
Cloneable,
StructuredPojo {
    private String catalogId;
    private String tagKey;
    private List<String> tagValues;

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public LFTagPair withCatalogId(String catalogId) {
        this.setCatalogId(catalogId);
        return this;
    }

    public void setTagKey(String tagKey) {
        this.tagKey = tagKey;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public LFTagPair withTagKey(String tagKey) {
        this.setTagKey(tagKey);
        return this;
    }

    public List<String> getTagValues() {
        return this.tagValues;
    }

    public void setTagValues(Collection<String> tagValues) {
        if (tagValues == null) {
            this.tagValues = null;
            return;
        }
        this.tagValues = new ArrayList<String>(tagValues);
    }

    public LFTagPair withTagValues(String ... tagValues) {
        if (this.tagValues == null) {
            this.setTagValues(new ArrayList<String>(tagValues.length));
        }
        for (String ele : tagValues) {
            this.tagValues.add(ele);
        }
        return this;
    }

    public LFTagPair withTagValues(Collection<String> tagValues) {
        this.setTagValues(tagValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: ").append(this.getCatalogId()).append(",");
        }
        if (this.getTagKey() != null) {
            sb.append("TagKey: ").append(this.getTagKey()).append(",");
        }
        if (this.getTagValues() != null) {
            sb.append("TagValues: ").append(this.getTagValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFTagPair)) {
            return false;
        }
        LFTagPair other = (LFTagPair)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getTagKey() == null ^ this.getTagKey() == null) {
            return false;
        }
        if (other.getTagKey() != null && !other.getTagKey().equals(this.getTagKey())) {
            return false;
        }
        if (other.getTagValues() == null ^ this.getTagValues() == null) {
            return false;
        }
        return other.getTagValues() == null || other.getTagValues().equals(this.getTagValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getTagKey() == null ? 0 : this.getTagKey().hashCode());
        hashCode = 31 * hashCode + (this.getTagValues() == null ? 0 : this.getTagValues().hashCode());
        return hashCode;
    }

    public LFTagPair clone() {
        try {
            return (LFTagPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LFTagPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

