/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.CodeContentUpdate;
import java.nio.ByteBuffer;

@SdkInternalApi
public class CodeContentUpdateMarshaller {
    private static final MarshallingInfo<String> TEXTCONTENTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextContentUpdate").build();
    private static final MarshallingInfo<ByteBuffer> ZIPFILECONTENTUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipFileContentUpdate").build();
    private static final MarshallingInfo<StructuredPojo> S3CONTENTLOCATIONUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ContentLocationUpdate").build();
    private static final CodeContentUpdateMarshaller instance = new CodeContentUpdateMarshaller();

    public static CodeContentUpdateMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeContentUpdate codeContentUpdate, ProtocolMarshaller protocolMarshaller) {
        if (codeContentUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeContentUpdate.getTextContentUpdate(), TEXTCONTENTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)codeContentUpdate.getZipFileContentUpdate(), ZIPFILECONTENTUPDATE_BINDING);
            protocolMarshaller.marshall((Object)codeContentUpdate.getS3ContentLocationUpdate(), S3CONTENTLOCATIONUPDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

