/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationVersionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ApplicationVersionSummary> applicationVersionSummaries;
    private String nextToken;

    public List<ApplicationVersionSummary> getApplicationVersionSummaries() {
        return this.applicationVersionSummaries;
    }

    public void setApplicationVersionSummaries(Collection<ApplicationVersionSummary> applicationVersionSummaries) {
        if (applicationVersionSummaries == null) {
            this.applicationVersionSummaries = null;
            return;
        }
        this.applicationVersionSummaries = new ArrayList<ApplicationVersionSummary>(applicationVersionSummaries);
    }

    public ListApplicationVersionsResult withApplicationVersionSummaries(ApplicationVersionSummary ... applicationVersionSummaries) {
        if (this.applicationVersionSummaries == null) {
            this.setApplicationVersionSummaries(new ArrayList<ApplicationVersionSummary>(applicationVersionSummaries.length));
        }
        for (ApplicationVersionSummary ele : applicationVersionSummaries) {
            this.applicationVersionSummaries.add(ele);
        }
        return this;
    }

    public ListApplicationVersionsResult withApplicationVersionSummaries(Collection<ApplicationVersionSummary> applicationVersionSummaries) {
        this.setApplicationVersionSummaries(applicationVersionSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationVersionSummaries() != null) {
            sb.append("ApplicationVersionSummaries: ").append(this.getApplicationVersionSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationVersionsResult)) {
            return false;
        }
        ListApplicationVersionsResult other = (ListApplicationVersionsResult)obj;
        if (other.getApplicationVersionSummaries() == null ^ this.getApplicationVersionSummaries() == null) {
            return false;
        }
        if (other.getApplicationVersionSummaries() != null && !other.getApplicationVersionSummaries().equals(this.getApplicationVersionSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationVersionSummaries() == null ? 0 : this.getApplicationVersionSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListApplicationVersionsResult clone() {
        try {
            return (ListApplicationVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

