/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate;
import com.amazonaws.services.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate;
import com.amazonaws.services.kinesisanalyticsv2.model.RunConfigurationUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private Long currentApplicationVersionId;
    private ApplicationConfigurationUpdate applicationConfigurationUpdate;
    private String serviceExecutionRoleUpdate;
    private RunConfigurationUpdate runConfigurationUpdate;
    private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;
    private String conditionalToken;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public UpdateApplicationRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
        this.currentApplicationVersionId = currentApplicationVersionId;
    }

    public Long getCurrentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public UpdateApplicationRequest withCurrentApplicationVersionId(Long currentApplicationVersionId) {
        this.setCurrentApplicationVersionId(currentApplicationVersionId);
        return this;
    }

    public void setApplicationConfigurationUpdate(ApplicationConfigurationUpdate applicationConfigurationUpdate) {
        this.applicationConfigurationUpdate = applicationConfigurationUpdate;
    }

    public ApplicationConfigurationUpdate getApplicationConfigurationUpdate() {
        return this.applicationConfigurationUpdate;
    }

    public UpdateApplicationRequest withApplicationConfigurationUpdate(ApplicationConfigurationUpdate applicationConfigurationUpdate) {
        this.setApplicationConfigurationUpdate(applicationConfigurationUpdate);
        return this;
    }

    public void setServiceExecutionRoleUpdate(String serviceExecutionRoleUpdate) {
        this.serviceExecutionRoleUpdate = serviceExecutionRoleUpdate;
    }

    public String getServiceExecutionRoleUpdate() {
        return this.serviceExecutionRoleUpdate;
    }

    public UpdateApplicationRequest withServiceExecutionRoleUpdate(String serviceExecutionRoleUpdate) {
        this.setServiceExecutionRoleUpdate(serviceExecutionRoleUpdate);
        return this;
    }

    public void setRunConfigurationUpdate(RunConfigurationUpdate runConfigurationUpdate) {
        this.runConfigurationUpdate = runConfigurationUpdate;
    }

    public RunConfigurationUpdate getRunConfigurationUpdate() {
        return this.runConfigurationUpdate;
    }

    public UpdateApplicationRequest withRunConfigurationUpdate(RunConfigurationUpdate runConfigurationUpdate) {
        this.setRunConfigurationUpdate(runConfigurationUpdate);
        return this;
    }

    public List<CloudWatchLoggingOptionUpdate> getCloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates;
    }

    public void setCloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
        if (cloudWatchLoggingOptionUpdates == null) {
            this.cloudWatchLoggingOptionUpdates = null;
            return;
        }
        this.cloudWatchLoggingOptionUpdates = new ArrayList<CloudWatchLoggingOptionUpdate>(cloudWatchLoggingOptionUpdates);
    }

    public UpdateApplicationRequest withCloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... cloudWatchLoggingOptionUpdates) {
        if (this.cloudWatchLoggingOptionUpdates == null) {
            this.setCloudWatchLoggingOptionUpdates(new ArrayList<CloudWatchLoggingOptionUpdate>(cloudWatchLoggingOptionUpdates.length));
        }
        for (CloudWatchLoggingOptionUpdate ele : cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates.add(ele);
        }
        return this;
    }

    public UpdateApplicationRequest withCloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
        this.setCloudWatchLoggingOptionUpdates(cloudWatchLoggingOptionUpdates);
        return this;
    }

    public void setConditionalToken(String conditionalToken) {
        this.conditionalToken = conditionalToken;
    }

    public String getConditionalToken() {
        return this.conditionalToken;
    }

    public UpdateApplicationRequest withConditionalToken(String conditionalToken) {
        this.setConditionalToken(conditionalToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getCurrentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.getCurrentApplicationVersionId()).append(",");
        }
        if (this.getApplicationConfigurationUpdate() != null) {
            sb.append("ApplicationConfigurationUpdate: ").append(this.getApplicationConfigurationUpdate()).append(",");
        }
        if (this.getServiceExecutionRoleUpdate() != null) {
            sb.append("ServiceExecutionRoleUpdate: ").append(this.getServiceExecutionRoleUpdate()).append(",");
        }
        if (this.getRunConfigurationUpdate() != null) {
            sb.append("RunConfigurationUpdate: ").append(this.getRunConfigurationUpdate()).append(",");
        }
        if (this.getCloudWatchLoggingOptionUpdates() != null) {
            sb.append("CloudWatchLoggingOptionUpdates: ").append(this.getCloudWatchLoggingOptionUpdates()).append(",");
        }
        if (this.getConditionalToken() != null) {
            sb.append("ConditionalToken: ").append(this.getConditionalToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getCurrentApplicationVersionId() == null ^ this.getCurrentApplicationVersionId() == null) {
            return false;
        }
        if (other.getCurrentApplicationVersionId() != null && !other.getCurrentApplicationVersionId().equals(this.getCurrentApplicationVersionId())) {
            return false;
        }
        if (other.getApplicationConfigurationUpdate() == null ^ this.getApplicationConfigurationUpdate() == null) {
            return false;
        }
        if (other.getApplicationConfigurationUpdate() != null && !other.getApplicationConfigurationUpdate().equals(this.getApplicationConfigurationUpdate())) {
            return false;
        }
        if (other.getServiceExecutionRoleUpdate() == null ^ this.getServiceExecutionRoleUpdate() == null) {
            return false;
        }
        if (other.getServiceExecutionRoleUpdate() != null && !other.getServiceExecutionRoleUpdate().equals(this.getServiceExecutionRoleUpdate())) {
            return false;
        }
        if (other.getRunConfigurationUpdate() == null ^ this.getRunConfigurationUpdate() == null) {
            return false;
        }
        if (other.getRunConfigurationUpdate() != null && !other.getRunConfigurationUpdate().equals(this.getRunConfigurationUpdate())) {
            return false;
        }
        if (other.getCloudWatchLoggingOptionUpdates() == null ^ this.getCloudWatchLoggingOptionUpdates() == null) {
            return false;
        }
        if (other.getCloudWatchLoggingOptionUpdates() != null && !other.getCloudWatchLoggingOptionUpdates().equals(this.getCloudWatchLoggingOptionUpdates())) {
            return false;
        }
        if (other.getConditionalToken() == null ^ this.getConditionalToken() == null) {
            return false;
        }
        return other.getConditionalToken() == null || other.getConditionalToken().equals(this.getConditionalToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentApplicationVersionId() == null ? 0 : this.getCurrentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationConfigurationUpdate() == null ? 0 : this.getApplicationConfigurationUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getServiceExecutionRoleUpdate() == null ? 0 : this.getServiceExecutionRoleUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getRunConfigurationUpdate() == null ? 0 : this.getRunConfigurationUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLoggingOptionUpdates() == null ? 0 : this.getCloudWatchLoggingOptionUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getConditionalToken() == null ? 0 : this.getConditionalToken().hashCode());
        return hashCode;
    }

    public UpdateApplicationRequest clone() {
        return (UpdateApplicationRequest)super.clone();
    }
}

