/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteApplicationVpcConfigurationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of an existing application.
     * </p>
     */
    private String applicationName;
    /**
     * <p>
     * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     * <code>ConditionalToken</code>. You can retrieve the application version ID using <a>DescribeApplication</a>. For
     * better concurrency support, use the <code>ConditionalToken</code> parameter instead of
     * <code>CurrentApplicationVersionId</code>.
     * </p>
     */
    private Long currentApplicationVersionId;
    /**
     * <p>
     * The ID of the VPC configuration to delete.
     * </p>
     */
    private String vpcConfigurationId;
    /**
     * <p>
     * A value you use to implement strong concurrency for application updates. You must provide the
     * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's current
     * <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use the
     * <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * </p>
     */
    private String conditionalToken;

    /**
     * <p>
     * The name of an existing application.
     * </p>
     * 
     * @param applicationName
     *        The name of an existing application.
     */

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    /**
     * <p>
     * The name of an existing application.
     * </p>
     * 
     * @return The name of an existing application.
     */

    public String getApplicationName() {
        return this.applicationName;
    }

    /**
     * <p>
     * The name of an existing application.
     * </p>
     * 
     * @param applicationName
     *        The name of an existing application.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteApplicationVpcConfigurationRequest withApplicationName(String applicationName) {
        setApplicationName(applicationName);
        return this;
    }

    /**
     * <p>
     * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     * <code>ConditionalToken</code>. You can retrieve the application version ID using <a>DescribeApplication</a>. For
     * better concurrency support, use the <code>ConditionalToken</code> parameter instead of
     * <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @param currentApplicationVersionId
     *        The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     *        <code>ConditionalToken</code>. You can retrieve the application version ID using
     *        <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
     *        parameter instead of <code>CurrentApplicationVersionId</code>.
     */

    public void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
        this.currentApplicationVersionId = currentApplicationVersionId;
    }

    /**
     * <p>
     * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     * <code>ConditionalToken</code>. You can retrieve the application version ID using <a>DescribeApplication</a>. For
     * better concurrency support, use the <code>ConditionalToken</code> parameter instead of
     * <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @return The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     *         <code>ConditionalToken</code>. You can retrieve the application version ID using
     *         <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
     *         parameter instead of <code>CurrentApplicationVersionId</code>.
     */

    public Long getCurrentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    /**
     * <p>
     * The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     * <code>ConditionalToken</code>. You can retrieve the application version ID using <a>DescribeApplication</a>. For
     * better concurrency support, use the <code>ConditionalToken</code> parameter instead of
     * <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @param currentApplicationVersionId
     *        The current application version ID. You must provide the <code>CurrentApplicationVersionId</code> or the
     *        <code>ConditionalToken</code>. You can retrieve the application version ID using
     *        <a>DescribeApplication</a>. For better concurrency support, use the <code>ConditionalToken</code>
     *        parameter instead of <code>CurrentApplicationVersionId</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteApplicationVpcConfigurationRequest withCurrentApplicationVersionId(Long currentApplicationVersionId) {
        setCurrentApplicationVersionId(currentApplicationVersionId);
        return this;
    }

    /**
     * <p>
     * The ID of the VPC configuration to delete.
     * </p>
     * 
     * @param vpcConfigurationId
     *        The ID of the VPC configuration to delete.
     */

    public void setVpcConfigurationId(String vpcConfigurationId) {
        this.vpcConfigurationId = vpcConfigurationId;
    }

    /**
     * <p>
     * The ID of the VPC configuration to delete.
     * </p>
     * 
     * @return The ID of the VPC configuration to delete.
     */

    public String getVpcConfigurationId() {
        return this.vpcConfigurationId;
    }

    /**
     * <p>
     * The ID of the VPC configuration to delete.
     * </p>
     * 
     * @param vpcConfigurationId
     *        The ID of the VPC configuration to delete.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteApplicationVpcConfigurationRequest withVpcConfigurationId(String vpcConfigurationId) {
        setVpcConfigurationId(vpcConfigurationId);
        return this;
    }

    /**
     * <p>
     * A value you use to implement strong concurrency for application updates. You must provide the
     * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's current
     * <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use the
     * <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @param conditionalToken
     *        A value you use to implement strong concurrency for application updates. You must provide the
     *        <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
     *        current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support,
     *        use the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     */

    public void setConditionalToken(String conditionalToken) {
        this.conditionalToken = conditionalToken;
    }

    /**
     * <p>
     * A value you use to implement strong concurrency for application updates. You must provide the
     * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's current
     * <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use the
     * <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @return A value you use to implement strong concurrency for application updates. You must provide the
     *         <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
     *         current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support,
     *         use the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     */

    public String getConditionalToken() {
        return this.conditionalToken;
    }

    /**
     * <p>
     * A value you use to implement strong concurrency for application updates. You must provide the
     * <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's current
     * <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support, use the
     * <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * </p>
     * 
     * @param conditionalToken
     *        A value you use to implement strong concurrency for application updates. You must provide the
     *        <code>CurrentApplicationVersionId</code> or the <code>ConditionalToken</code>. You get the application's
     *        current <code>ConditionalToken</code> using <a>DescribeApplication</a>. For better concurrency support,
     *        use the <code>ConditionalToken</code> parameter instead of <code>CurrentApplicationVersionId</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteApplicationVpcConfigurationRequest withConditionalToken(String conditionalToken) {
        setConditionalToken(conditionalToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getApplicationName() != null)
            sb.append("ApplicationName: ").append(getApplicationName()).append(",");
        if (getCurrentApplicationVersionId() != null)
            sb.append("CurrentApplicationVersionId: ").append(getCurrentApplicationVersionId()).append(",");
        if (getVpcConfigurationId() != null)
            sb.append("VpcConfigurationId: ").append(getVpcConfigurationId()).append(",");
        if (getConditionalToken() != null)
            sb.append("ConditionalToken: ").append(getConditionalToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteApplicationVpcConfigurationRequest == false)
            return false;
        DeleteApplicationVpcConfigurationRequest other = (DeleteApplicationVpcConfigurationRequest) obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null)
            return false;
        if (other.getApplicationName() != null && other.getApplicationName().equals(this.getApplicationName()) == false)
            return false;
        if (other.getCurrentApplicationVersionId() == null ^ this.getCurrentApplicationVersionId() == null)
            return false;
        if (other.getCurrentApplicationVersionId() != null && other.getCurrentApplicationVersionId().equals(this.getCurrentApplicationVersionId()) == false)
            return false;
        if (other.getVpcConfigurationId() == null ^ this.getVpcConfigurationId() == null)
            return false;
        if (other.getVpcConfigurationId() != null && other.getVpcConfigurationId().equals(this.getVpcConfigurationId()) == false)
            return false;
        if (other.getConditionalToken() == null ^ this.getConditionalToken() == null)
            return false;
        if (other.getConditionalToken() != null && other.getConditionalToken().equals(this.getConditionalToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getApplicationName() == null) ? 0 : getApplicationName().hashCode());
        hashCode = prime * hashCode + ((getCurrentApplicationVersionId() == null) ? 0 : getCurrentApplicationVersionId().hashCode());
        hashCode = prime * hashCode + ((getVpcConfigurationId() == null) ? 0 : getVpcConfigurationId().hashCode());
        hashCode = prime * hashCode + ((getConditionalToken() == null) ? 0 : getConditionalToken().hashCode());
        return hashCode;
    }

    @Override
    public DeleteApplicationVpcConfigurationRequest clone() {
        return (DeleteApplicationVpcConfigurationRequest) super.clone();
    }

}
