/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.transform.ReferenceDataSourceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AddApplicationReferenceDataSourceRequestMarshaller
implements Marshaller<Request<AddApplicationReferenceDataSourceRequest>, AddApplicationReferenceDataSourceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AddApplicationReferenceDataSourceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AddApplicationReferenceDataSourceRequest> marshall(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        if (addApplicationReferenceDataSourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addApplicationReferenceDataSourceRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.AddApplicationReferenceDataSource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addApplicationReferenceDataSourceRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(addApplicationReferenceDataSourceRequest.getApplicationName());
            }
            if (addApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(addApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId().longValue());
            }
            if (addApplicationReferenceDataSourceRequest.getReferenceDataSource() != null) {
                jsonGenerator.writeFieldName("ReferenceDataSource");
                ReferenceDataSourceJsonMarshaller.getInstance().marshall(addApplicationReferenceDataSourceRequest.getReferenceDataSource(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

