/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.ProcessingConfiguration;
import com.amazonaws.services.kinesisfirehose.model.Processor;
import com.amazonaws.services.kinesisfirehose.model.transform.ProcessorJsonMarshaller;
import java.util.List;

public class ProcessingConfigurationJsonMarshaller {
    private static ProcessingConfigurationJsonMarshaller instance;

    public void marshall(ProcessingConfiguration processingConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (processingConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Processor> processorsList;
            jsonGenerator.writeStartObject();
            if (processingConfiguration.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(processingConfiguration.getEnabled().booleanValue());
            }
            if ((processorsList = processingConfiguration.getProcessors()) != null) {
                jsonGenerator.writeFieldName("Processors");
                jsonGenerator.writeStartArray();
                for (Processor processorsListValue : processorsList) {
                    if (processorsListValue == null) continue;
                    ProcessorJsonMarshaller.getInstance().marshall(processorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProcessingConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProcessingConfigurationJsonMarshaller();
        }
        return instance;
    }
}

