/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.transform.HashKeyRangeJsonMarshaller;
import com.amazonaws.services.kinesis.model.transform.SequenceNumberRangeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class ShardJsonMarshaller {
    private static ShardJsonMarshaller instance;

    public void marshall(Shard shard, SdkJsonGenerator jsonGenerator) {
        if (shard == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (shard.getShardId() != null) {
                jsonGenerator.writeFieldName("ShardId").writeValue(shard.getShardId());
            }
            if (shard.getParentShardId() != null) {
                jsonGenerator.writeFieldName("ParentShardId").writeValue(shard.getParentShardId());
            }
            if (shard.getAdjacentParentShardId() != null) {
                jsonGenerator.writeFieldName("AdjacentParentShardId").writeValue(shard.getAdjacentParentShardId());
            }
            if (shard.getHashKeyRange() != null) {
                jsonGenerator.writeFieldName("HashKeyRange");
                HashKeyRangeJsonMarshaller.getInstance().marshall(shard.getHashKeyRange(), jsonGenerator);
            }
            if (shard.getSequenceNumberRange() != null) {
                jsonGenerator.writeFieldName("SequenceNumberRange");
                SequenceNumberRangeJsonMarshaller.getInstance().marshall(shard.getSequenceNumberRange(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShardJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShardJsonMarshaller();
        }
        return instance;
    }
}

