/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.services.kendra.model.ExpandConfiguration;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ExpandConfigurationJsonUnmarshaller
implements Unmarshaller<ExpandConfiguration, JsonUnmarshallerContext> {
    private static ExpandConfigurationJsonUnmarshaller instance;

    public ExpandConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        ExpandConfiguration expandConfiguration = new ExpandConfiguration();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MaxResultItemsToExpand", targetDepth)) {
                    context.nextToken();
                    expandConfiguration.setMaxResultItemsToExpand((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxExpandedResultsPerItem", targetDepth)) {
                    context.nextToken();
                    expandConfiguration.setMaxExpandedResultsPerItem((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return expandConfiguration;
    }

    public static ExpandConfigurationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExpandConfigurationJsonUnmarshaller();
        }
        return instance;
    }
}

