/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.ClusterOperationStep;
import com.amazonaws.services.kafka.model.MutableClusterInfo;
import com.amazonaws.services.kafka.model.VpcConnectionInfo;
import com.amazonaws.services.kafka.model.transform.ClusterOperationV2ProvisionedMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterOperationV2Provisioned
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ClusterOperationStep> operationSteps;
    private MutableClusterInfo sourceClusterInfo;
    private MutableClusterInfo targetClusterInfo;
    private VpcConnectionInfo vpcConnectionInfo;

    public List<ClusterOperationStep> getOperationSteps() {
        return this.operationSteps;
    }

    public void setOperationSteps(Collection<ClusterOperationStep> operationSteps) {
        if (operationSteps == null) {
            this.operationSteps = null;
            return;
        }
        this.operationSteps = new ArrayList<ClusterOperationStep>(operationSteps);
    }

    public ClusterOperationV2Provisioned withOperationSteps(ClusterOperationStep ... operationSteps) {
        if (this.operationSteps == null) {
            this.setOperationSteps(new ArrayList<ClusterOperationStep>(operationSteps.length));
        }
        for (ClusterOperationStep ele : operationSteps) {
            this.operationSteps.add(ele);
        }
        return this;
    }

    public ClusterOperationV2Provisioned withOperationSteps(Collection<ClusterOperationStep> operationSteps) {
        this.setOperationSteps(operationSteps);
        return this;
    }

    public void setSourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
        this.sourceClusterInfo = sourceClusterInfo;
    }

    public MutableClusterInfo getSourceClusterInfo() {
        return this.sourceClusterInfo;
    }

    public ClusterOperationV2Provisioned withSourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
        this.setSourceClusterInfo(sourceClusterInfo);
        return this;
    }

    public void setTargetClusterInfo(MutableClusterInfo targetClusterInfo) {
        this.targetClusterInfo = targetClusterInfo;
    }

    public MutableClusterInfo getTargetClusterInfo() {
        return this.targetClusterInfo;
    }

    public ClusterOperationV2Provisioned withTargetClusterInfo(MutableClusterInfo targetClusterInfo) {
        this.setTargetClusterInfo(targetClusterInfo);
        return this;
    }

    public void setVpcConnectionInfo(VpcConnectionInfo vpcConnectionInfo) {
        this.vpcConnectionInfo = vpcConnectionInfo;
    }

    public VpcConnectionInfo getVpcConnectionInfo() {
        return this.vpcConnectionInfo;
    }

    public ClusterOperationV2Provisioned withVpcConnectionInfo(VpcConnectionInfo vpcConnectionInfo) {
        this.setVpcConnectionInfo(vpcConnectionInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperationSteps() != null) {
            sb.append("OperationSteps: ").append(this.getOperationSteps()).append(",");
        }
        if (this.getSourceClusterInfo() != null) {
            sb.append("SourceClusterInfo: ").append(this.getSourceClusterInfo()).append(",");
        }
        if (this.getTargetClusterInfo() != null) {
            sb.append("TargetClusterInfo: ").append(this.getTargetClusterInfo()).append(",");
        }
        if (this.getVpcConnectionInfo() != null) {
            sb.append("VpcConnectionInfo: ").append(this.getVpcConnectionInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationV2Provisioned)) {
            return false;
        }
        ClusterOperationV2Provisioned other = (ClusterOperationV2Provisioned)obj;
        if (other.getOperationSteps() == null ^ this.getOperationSteps() == null) {
            return false;
        }
        if (other.getOperationSteps() != null && !other.getOperationSteps().equals(this.getOperationSteps())) {
            return false;
        }
        if (other.getSourceClusterInfo() == null ^ this.getSourceClusterInfo() == null) {
            return false;
        }
        if (other.getSourceClusterInfo() != null && !other.getSourceClusterInfo().equals(this.getSourceClusterInfo())) {
            return false;
        }
        if (other.getTargetClusterInfo() == null ^ this.getTargetClusterInfo() == null) {
            return false;
        }
        if (other.getTargetClusterInfo() != null && !other.getTargetClusterInfo().equals(this.getTargetClusterInfo())) {
            return false;
        }
        if (other.getVpcConnectionInfo() == null ^ this.getVpcConnectionInfo() == null) {
            return false;
        }
        return other.getVpcConnectionInfo() == null || other.getVpcConnectionInfo().equals(this.getVpcConnectionInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperationSteps() == null ? 0 : this.getOperationSteps().hashCode());
        hashCode = 31 * hashCode + (this.getSourceClusterInfo() == null ? 0 : this.getSourceClusterInfo().hashCode());
        hashCode = 31 * hashCode + (this.getTargetClusterInfo() == null ? 0 : this.getTargetClusterInfo().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConnectionInfo() == null ? 0 : this.getVpcConnectionInfo().hashCode());
        return hashCode;
    }

    public ClusterOperationV2Provisioned clone() {
        try {
            return (ClusterOperationV2Provisioned)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterOperationV2ProvisionedMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

