/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivsrealtime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ivsrealtime.model.ParticipantSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListParticipantsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ParticipantSummary> participants;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListParticipantsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ParticipantSummary> getParticipants() {
        return this.participants;
    }

    public void setParticipants(Collection<ParticipantSummary> participants) {
        if (participants == null) {
            this.participants = null;
            return;
        }
        this.participants = new ArrayList<ParticipantSummary>(participants);
    }

    public ListParticipantsResult withParticipants(ParticipantSummary ... participants) {
        if (this.participants == null) {
            this.setParticipants(new ArrayList<ParticipantSummary>(participants.length));
        }
        for (ParticipantSummary ele : participants) {
            this.participants.add(ele);
        }
        return this;
    }

    public ListParticipantsResult withParticipants(Collection<ParticipantSummary> participants) {
        this.setParticipants(participants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getParticipants() != null) {
            sb.append("Participants: ").append(this.getParticipants());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParticipantsResult)) {
            return false;
        }
        ListParticipantsResult other = (ListParticipantsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getParticipants() == null ^ this.getParticipants() == null) {
            return false;
        }
        return other.getParticipants() == null || other.getParticipants().equals(this.getParticipants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getParticipants() == null ? 0 : this.getParticipants().hashCode());
        return hashCode;
    }

    public ListParticipantsResult clone() {
        try {
            return (ListParticipantsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

