/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivschat.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ivschat.model.ChatTokenCapability;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateChatTokenRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, String> attributes;
    private List<String> capabilities;
    private String roomIdentifier;
    private Integer sessionDurationInMinutes;
    private String userId;

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CreateChatTokenRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public CreateChatTokenRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public CreateChatTokenRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<String>(capabilities);
    }

    public CreateChatTokenRequest withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public CreateChatTokenRequest withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public CreateChatTokenRequest withCapabilities(ChatTokenCapability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (ChatTokenCapability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public void setRoomIdentifier(String roomIdentifier) {
        this.roomIdentifier = roomIdentifier;
    }

    public String getRoomIdentifier() {
        return this.roomIdentifier;
    }

    public CreateChatTokenRequest withRoomIdentifier(String roomIdentifier) {
        this.setRoomIdentifier(roomIdentifier);
        return this;
    }

    public void setSessionDurationInMinutes(Integer sessionDurationInMinutes) {
        this.sessionDurationInMinutes = sessionDurationInMinutes;
    }

    public Integer getSessionDurationInMinutes() {
        return this.sessionDurationInMinutes;
    }

    public CreateChatTokenRequest withSessionDurationInMinutes(Integer sessionDurationInMinutes) {
        this.setSessionDurationInMinutes(sessionDurationInMinutes);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public CreateChatTokenRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getRoomIdentifier() != null) {
            sb.append("RoomIdentifier: ").append(this.getRoomIdentifier()).append(",");
        }
        if (this.getSessionDurationInMinutes() != null) {
            sb.append("SessionDurationInMinutes: ").append(this.getSessionDurationInMinutes()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChatTokenRequest)) {
            return false;
        }
        CreateChatTokenRequest other = (CreateChatTokenRequest)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getRoomIdentifier() == null ^ this.getRoomIdentifier() == null) {
            return false;
        }
        if (other.getRoomIdentifier() != null && !other.getRoomIdentifier().equals(this.getRoomIdentifier())) {
            return false;
        }
        if (other.getSessionDurationInMinutes() == null ^ this.getSessionDurationInMinutes() == null) {
            return false;
        }
        if (other.getSessionDurationInMinutes() != null && !other.getSessionDurationInMinutes().equals(this.getSessionDurationInMinutes())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        return other.getUserId() == null || other.getUserId().equals(this.getUserId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getRoomIdentifier() == null ? 0 : this.getRoomIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSessionDurationInMinutes() == null ? 0 : this.getSessionDurationInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        return hashCode;
    }

    public CreateChatTokenRequest clone() {
        return (CreateChatTokenRequest)super.clone();
    }
}

