/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ivs.model.transform.AudioConfigurationMarshaller;
import java.io.Serializable;

public class AudioConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String codec;
    private Long targetBitrate;
    private Long sampleRate;
    private Long channels;

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getCodec() {
        return this.codec;
    }

    public AudioConfiguration withCodec(String codec) {
        this.setCodec(codec);
        return this;
    }

    public void setTargetBitrate(Long targetBitrate) {
        this.targetBitrate = targetBitrate;
    }

    public Long getTargetBitrate() {
        return this.targetBitrate;
    }

    public AudioConfiguration withTargetBitrate(Long targetBitrate) {
        this.setTargetBitrate(targetBitrate);
        return this;
    }

    public void setSampleRate(Long sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Long getSampleRate() {
        return this.sampleRate;
    }

    public AudioConfiguration withSampleRate(Long sampleRate) {
        this.setSampleRate(sampleRate);
        return this;
    }

    public void setChannels(Long channels) {
        this.channels = channels;
    }

    public Long getChannels() {
        return this.channels;
    }

    public AudioConfiguration withChannels(Long channels) {
        this.setChannels(channels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodec() != null) {
            sb.append("Codec: ").append(this.getCodec()).append(",");
        }
        if (this.getTargetBitrate() != null) {
            sb.append("TargetBitrate: ").append(this.getTargetBitrate()).append(",");
        }
        if (this.getSampleRate() != null) {
            sb.append("SampleRate: ").append(this.getSampleRate()).append(",");
        }
        if (this.getChannels() != null) {
            sb.append("Channels: ").append(this.getChannels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioConfiguration)) {
            return false;
        }
        AudioConfiguration other = (AudioConfiguration)obj;
        if (other.getCodec() == null ^ this.getCodec() == null) {
            return false;
        }
        if (other.getCodec() != null && !other.getCodec().equals(this.getCodec())) {
            return false;
        }
        if (other.getTargetBitrate() == null ^ this.getTargetBitrate() == null) {
            return false;
        }
        if (other.getTargetBitrate() != null && !other.getTargetBitrate().equals(this.getTargetBitrate())) {
            return false;
        }
        if (other.getSampleRate() == null ^ this.getSampleRate() == null) {
            return false;
        }
        if (other.getSampleRate() != null && !other.getSampleRate().equals(this.getSampleRate())) {
            return false;
        }
        if (other.getChannels() == null ^ this.getChannels() == null) {
            return false;
        }
        return other.getChannels() == null || other.getChannels().equals(this.getChannels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodec() == null ? 0 : this.getCodec().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBitrate() == null ? 0 : this.getTargetBitrate().hashCode());
        hashCode = 31 * hashCode + (this.getSampleRate() == null ? 0 : this.getSampleRate().hashCode());
        hashCode = 31 * hashCode + (this.getChannels() == null ? 0 : this.getChannels().hashCode());
        return hashCode;
    }

    public AudioConfiguration clone() {
        try {
            return (AudioConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

