/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ivs.AmazonIVS;
import com.amazonaws.services.ivs.AmazonIVSClientBuilder;
import com.amazonaws.services.ivs.model.AmazonIVSException;
import com.amazonaws.services.ivs.model.BatchGetChannelRequest;
import com.amazonaws.services.ivs.model.BatchGetChannelResult;
import com.amazonaws.services.ivs.model.BatchGetStreamKeyRequest;
import com.amazonaws.services.ivs.model.BatchGetStreamKeyResult;
import com.amazonaws.services.ivs.model.BatchStartViewerSessionRevocationRequest;
import com.amazonaws.services.ivs.model.BatchStartViewerSessionRevocationResult;
import com.amazonaws.services.ivs.model.CreateChannelRequest;
import com.amazonaws.services.ivs.model.CreateChannelResult;
import com.amazonaws.services.ivs.model.CreateRecordingConfigurationRequest;
import com.amazonaws.services.ivs.model.CreateRecordingConfigurationResult;
import com.amazonaws.services.ivs.model.CreateStreamKeyRequest;
import com.amazonaws.services.ivs.model.CreateStreamKeyResult;
import com.amazonaws.services.ivs.model.DeleteChannelRequest;
import com.amazonaws.services.ivs.model.DeleteChannelResult;
import com.amazonaws.services.ivs.model.DeletePlaybackKeyPairRequest;
import com.amazonaws.services.ivs.model.DeletePlaybackKeyPairResult;
import com.amazonaws.services.ivs.model.DeleteRecordingConfigurationRequest;
import com.amazonaws.services.ivs.model.DeleteRecordingConfigurationResult;
import com.amazonaws.services.ivs.model.DeleteStreamKeyRequest;
import com.amazonaws.services.ivs.model.DeleteStreamKeyResult;
import com.amazonaws.services.ivs.model.GetChannelRequest;
import com.amazonaws.services.ivs.model.GetChannelResult;
import com.amazonaws.services.ivs.model.GetPlaybackKeyPairRequest;
import com.amazonaws.services.ivs.model.GetPlaybackKeyPairResult;
import com.amazonaws.services.ivs.model.GetRecordingConfigurationRequest;
import com.amazonaws.services.ivs.model.GetRecordingConfigurationResult;
import com.amazonaws.services.ivs.model.GetStreamKeyRequest;
import com.amazonaws.services.ivs.model.GetStreamKeyResult;
import com.amazonaws.services.ivs.model.GetStreamRequest;
import com.amazonaws.services.ivs.model.GetStreamResult;
import com.amazonaws.services.ivs.model.GetStreamSessionRequest;
import com.amazonaws.services.ivs.model.GetStreamSessionResult;
import com.amazonaws.services.ivs.model.ImportPlaybackKeyPairRequest;
import com.amazonaws.services.ivs.model.ImportPlaybackKeyPairResult;
import com.amazonaws.services.ivs.model.ListChannelsRequest;
import com.amazonaws.services.ivs.model.ListChannelsResult;
import com.amazonaws.services.ivs.model.ListPlaybackKeyPairsRequest;
import com.amazonaws.services.ivs.model.ListPlaybackKeyPairsResult;
import com.amazonaws.services.ivs.model.ListRecordingConfigurationsRequest;
import com.amazonaws.services.ivs.model.ListRecordingConfigurationsResult;
import com.amazonaws.services.ivs.model.ListStreamKeysRequest;
import com.amazonaws.services.ivs.model.ListStreamKeysResult;
import com.amazonaws.services.ivs.model.ListStreamSessionsRequest;
import com.amazonaws.services.ivs.model.ListStreamSessionsResult;
import com.amazonaws.services.ivs.model.ListStreamsRequest;
import com.amazonaws.services.ivs.model.ListStreamsResult;
import com.amazonaws.services.ivs.model.ListTagsForResourceRequest;
import com.amazonaws.services.ivs.model.ListTagsForResourceResult;
import com.amazonaws.services.ivs.model.PutMetadataRequest;
import com.amazonaws.services.ivs.model.PutMetadataResult;
import com.amazonaws.services.ivs.model.StartViewerSessionRevocationRequest;
import com.amazonaws.services.ivs.model.StartViewerSessionRevocationResult;
import com.amazonaws.services.ivs.model.StopStreamRequest;
import com.amazonaws.services.ivs.model.StopStreamResult;
import com.amazonaws.services.ivs.model.TagResourceRequest;
import com.amazonaws.services.ivs.model.TagResourceResult;
import com.amazonaws.services.ivs.model.UntagResourceRequest;
import com.amazonaws.services.ivs.model.UntagResourceResult;
import com.amazonaws.services.ivs.model.UpdateChannelRequest;
import com.amazonaws.services.ivs.model.UpdateChannelResult;
import com.amazonaws.services.ivs.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.BatchGetChannelRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.BatchGetChannelResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.BatchGetStreamKeyRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.BatchGetStreamKeyResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.BatchStartViewerSessionRevocationRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.BatchStartViewerSessionRevocationResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ChannelNotBroadcastingExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.CreateRecordingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.CreateRecordingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.CreateStreamKeyRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.CreateStreamKeyResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.DeletePlaybackKeyPairRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.DeletePlaybackKeyPairResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.DeleteRecordingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.DeleteRecordingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.DeleteStreamKeyRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.DeleteStreamKeyResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.GetChannelRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.GetChannelResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.GetPlaybackKeyPairRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.GetPlaybackKeyPairResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.GetRecordingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.GetRecordingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.GetStreamKeyRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.GetStreamKeyResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.GetStreamRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.GetStreamResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.GetStreamSessionRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.GetStreamSessionResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ImportPlaybackKeyPairRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ImportPlaybackKeyPairResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListPlaybackKeyPairsRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListPlaybackKeyPairsResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListRecordingConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListRecordingConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListStreamKeysRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListStreamKeysResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListStreamSessionsRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListStreamSessionsResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListStreamsRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListStreamsResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.PendingVerificationExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.PutMetadataRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.PutMetadataResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.StartViewerSessionRevocationRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.StartViewerSessionRevocationResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.StopStreamRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.StopStreamResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.StreamUnavailableExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.ivs.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.ivs.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.ivs.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonIVSClient
extends AmazonWebServiceClient
implements AmazonIVS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonIVS.class);
    private static final String DEFAULT_SIGNING_NAME = "ivs";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StreamUnavailable").withExceptionUnmarshaller((JsonErrorUnmarshaller)StreamUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ChannelNotBroadcasting").withExceptionUnmarshaller((JsonErrorUnmarshaller)ChannelNotBroadcastingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PendingVerification").withExceptionUnmarshaller((JsonErrorUnmarshaller)PendingVerificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonIVSException.class));

    public static AmazonIVSClientBuilder builder() {
        return AmazonIVSClientBuilder.standard();
    }

    AmazonIVSClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonIVSClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ivs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ivs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ivs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetChannelResult batchGetChannel(BatchGetChannelRequest request) {
        request = (BatchGetChannelRequest)this.beforeClientExecution(request);
        return this.executeBatchGetChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetChannelResult executeBatchGetChannel(BatchGetChannelRequest batchGetChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetChannelRequestProtocolMarshaller(protocolFactory).marshall((BatchGetChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetChannelResult batchGetChannelResult = (BatchGetChannelResult)response.getAwsResponse();
            return batchGetChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetStreamKeyResult batchGetStreamKey(BatchGetStreamKeyRequest request) {
        request = (BatchGetStreamKeyRequest)this.beforeClientExecution(request);
        return this.executeBatchGetStreamKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetStreamKeyResult executeBatchGetStreamKey(BatchGetStreamKeyRequest batchGetStreamKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetStreamKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetStreamKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetStreamKeyRequestProtocolMarshaller(protocolFactory).marshall((BatchGetStreamKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetStreamKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetStreamKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetStreamKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetStreamKeyResult batchGetStreamKeyResult = (BatchGetStreamKeyResult)response.getAwsResponse();
            return batchGetStreamKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchStartViewerSessionRevocationResult batchStartViewerSessionRevocation(BatchStartViewerSessionRevocationRequest request) {
        request = (BatchStartViewerSessionRevocationRequest)this.beforeClientExecution(request);
        return this.executeBatchStartViewerSessionRevocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchStartViewerSessionRevocationResult executeBatchStartViewerSessionRevocation(BatchStartViewerSessionRevocationRequest batchStartViewerSessionRevocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchStartViewerSessionRevocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchStartViewerSessionRevocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchStartViewerSessionRevocationRequestProtocolMarshaller(protocolFactory).marshall((BatchStartViewerSessionRevocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchStartViewerSessionRevocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchStartViewerSessionRevocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchStartViewerSessionRevocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchStartViewerSessionRevocationResult batchStartViewerSessionRevocationResult = (BatchStartViewerSessionRevocationResult)response.getAwsResponse();
            return batchStartViewerSessionRevocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRecordingConfigurationResult createRecordingConfiguration(CreateRecordingConfigurationRequest request) {
        request = (CreateRecordingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreateRecordingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRecordingConfigurationResult executeCreateRecordingConfiguration(CreateRecordingConfigurationRequest createRecordingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRecordingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRecordingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRecordingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreateRecordingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRecordingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRecordingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRecordingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRecordingConfigurationResult createRecordingConfigurationResult = (CreateRecordingConfigurationResult)response.getAwsResponse();
            return createRecordingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStreamKeyResult createStreamKey(CreateStreamKeyRequest request) {
        request = (CreateStreamKeyRequest)this.beforeClientExecution(request);
        return this.executeCreateStreamKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateStreamKeyResult executeCreateStreamKey(CreateStreamKeyRequest createStreamKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStreamKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateStreamKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateStreamKeyRequestProtocolMarshaller(protocolFactory).marshall((CreateStreamKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createStreamKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateStreamKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateStreamKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateStreamKeyResult createStreamKeyResult = (CreateStreamKeyResult)response.getAwsResponse();
            return createStreamKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePlaybackKeyPairResult deletePlaybackKeyPair(DeletePlaybackKeyPairRequest request) {
        request = (DeletePlaybackKeyPairRequest)this.beforeClientExecution(request);
        return this.executeDeletePlaybackKeyPair(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePlaybackKeyPairResult executeDeletePlaybackKeyPair(DeletePlaybackKeyPairRequest deletePlaybackKeyPairRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePlaybackKeyPairRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePlaybackKeyPairRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePlaybackKeyPairRequestProtocolMarshaller(protocolFactory).marshall((DeletePlaybackKeyPairRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePlaybackKeyPairRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePlaybackKeyPair");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePlaybackKeyPairResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePlaybackKeyPairResult deletePlaybackKeyPairResult = (DeletePlaybackKeyPairResult)response.getAwsResponse();
            return deletePlaybackKeyPairResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRecordingConfigurationResult deleteRecordingConfiguration(DeleteRecordingConfigurationRequest request) {
        request = (DeleteRecordingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeleteRecordingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRecordingConfigurationResult executeDeleteRecordingConfiguration(DeleteRecordingConfigurationRequest deleteRecordingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRecordingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRecordingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRecordingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeleteRecordingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRecordingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRecordingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRecordingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRecordingConfigurationResult deleteRecordingConfigurationResult = (DeleteRecordingConfigurationResult)response.getAwsResponse();
            return deleteRecordingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteStreamKeyResult deleteStreamKey(DeleteStreamKeyRequest request) {
        request = (DeleteStreamKeyRequest)this.beforeClientExecution(request);
        return this.executeDeleteStreamKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteStreamKeyResult executeDeleteStreamKey(DeleteStreamKeyRequest deleteStreamKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStreamKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteStreamKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteStreamKeyRequestProtocolMarshaller(protocolFactory).marshall((DeleteStreamKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteStreamKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteStreamKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteStreamKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteStreamKeyResult deleteStreamKeyResult = (DeleteStreamKeyResult)response.getAwsResponse();
            return deleteStreamKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChannelResult getChannel(GetChannelRequest request) {
        request = (GetChannelRequest)this.beforeClientExecution(request);
        return this.executeGetChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChannelResult executeGetChannel(GetChannelRequest getChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChannelRequestProtocolMarshaller(protocolFactory).marshall((GetChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChannelResult getChannelResult = (GetChannelResult)response.getAwsResponse();
            return getChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPlaybackKeyPairResult getPlaybackKeyPair(GetPlaybackKeyPairRequest request) {
        request = (GetPlaybackKeyPairRequest)this.beforeClientExecution(request);
        return this.executeGetPlaybackKeyPair(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPlaybackKeyPairResult executeGetPlaybackKeyPair(GetPlaybackKeyPairRequest getPlaybackKeyPairRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPlaybackKeyPairRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPlaybackKeyPairRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPlaybackKeyPairRequestProtocolMarshaller(protocolFactory).marshall((GetPlaybackKeyPairRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPlaybackKeyPairRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPlaybackKeyPair");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPlaybackKeyPairResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPlaybackKeyPairResult getPlaybackKeyPairResult = (GetPlaybackKeyPairResult)response.getAwsResponse();
            return getPlaybackKeyPairResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecordingConfigurationResult getRecordingConfiguration(GetRecordingConfigurationRequest request) {
        request = (GetRecordingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetRecordingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecordingConfigurationResult executeGetRecordingConfiguration(GetRecordingConfigurationRequest getRecordingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecordingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecordingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecordingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetRecordingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecordingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecordingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecordingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecordingConfigurationResult getRecordingConfigurationResult = (GetRecordingConfigurationResult)response.getAwsResponse();
            return getRecordingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStreamResult getStream(GetStreamRequest request) {
        request = (GetStreamRequest)this.beforeClientExecution(request);
        return this.executeGetStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStreamResult executeGetStream(GetStreamRequest getStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStreamRequestProtocolMarshaller(protocolFactory).marshall((GetStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStreamResult getStreamResult = (GetStreamResult)response.getAwsResponse();
            return getStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStreamKeyResult getStreamKey(GetStreamKeyRequest request) {
        request = (GetStreamKeyRequest)this.beforeClientExecution(request);
        return this.executeGetStreamKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStreamKeyResult executeGetStreamKey(GetStreamKeyRequest getStreamKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStreamKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStreamKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStreamKeyRequestProtocolMarshaller(protocolFactory).marshall((GetStreamKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStreamKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStreamKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetStreamKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStreamKeyResult getStreamKeyResult = (GetStreamKeyResult)response.getAwsResponse();
            return getStreamKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetStreamSessionResult getStreamSession(GetStreamSessionRequest request) {
        request = (GetStreamSessionRequest)this.beforeClientExecution(request);
        return this.executeGetStreamSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetStreamSessionResult executeGetStreamSession(GetStreamSessionRequest getStreamSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStreamSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetStreamSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetStreamSessionRequestProtocolMarshaller(protocolFactory).marshall((GetStreamSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getStreamSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetStreamSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetStreamSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetStreamSessionResult getStreamSessionResult = (GetStreamSessionResult)response.getAwsResponse();
            return getStreamSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportPlaybackKeyPairResult importPlaybackKeyPair(ImportPlaybackKeyPairRequest request) {
        request = (ImportPlaybackKeyPairRequest)this.beforeClientExecution(request);
        return this.executeImportPlaybackKeyPair(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportPlaybackKeyPairResult executeImportPlaybackKeyPair(ImportPlaybackKeyPairRequest importPlaybackKeyPairRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importPlaybackKeyPairRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportPlaybackKeyPairRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportPlaybackKeyPairRequestProtocolMarshaller(protocolFactory).marshall((ImportPlaybackKeyPairRequest)super.beforeMarshalling((AmazonWebServiceRequest)importPlaybackKeyPairRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportPlaybackKeyPair");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportPlaybackKeyPairResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportPlaybackKeyPairResult importPlaybackKeyPairResult = (ImportPlaybackKeyPairResult)response.getAwsResponse();
            return importPlaybackKeyPairResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPlaybackKeyPairsResult listPlaybackKeyPairs(ListPlaybackKeyPairsRequest request) {
        request = (ListPlaybackKeyPairsRequest)this.beforeClientExecution(request);
        return this.executeListPlaybackKeyPairs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPlaybackKeyPairsResult executeListPlaybackKeyPairs(ListPlaybackKeyPairsRequest listPlaybackKeyPairsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPlaybackKeyPairsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPlaybackKeyPairsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPlaybackKeyPairsRequestProtocolMarshaller(protocolFactory).marshall((ListPlaybackKeyPairsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPlaybackKeyPairsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPlaybackKeyPairs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPlaybackKeyPairsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPlaybackKeyPairsResult listPlaybackKeyPairsResult = (ListPlaybackKeyPairsResult)response.getAwsResponse();
            return listPlaybackKeyPairsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecordingConfigurationsResult listRecordingConfigurations(ListRecordingConfigurationsRequest request) {
        request = (ListRecordingConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListRecordingConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecordingConfigurationsResult executeListRecordingConfigurations(ListRecordingConfigurationsRequest listRecordingConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecordingConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecordingConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecordingConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListRecordingConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRecordingConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRecordingConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecordingConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecordingConfigurationsResult listRecordingConfigurationsResult = (ListRecordingConfigurationsResult)response.getAwsResponse();
            return listRecordingConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamKeysResult listStreamKeys(ListStreamKeysRequest request) {
        request = (ListStreamKeysRequest)this.beforeClientExecution(request);
        return this.executeListStreamKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStreamKeysResult executeListStreamKeys(ListStreamKeysRequest listStreamKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStreamKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStreamKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStreamKeysRequestProtocolMarshaller(protocolFactory).marshall((ListStreamKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStreamKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStreamKeys");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStreamKeysResult listStreamKeysResult = (ListStreamKeysResult)response.getAwsResponse();
            return listStreamKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamSessionsResult listStreamSessions(ListStreamSessionsRequest request) {
        request = (ListStreamSessionsRequest)this.beforeClientExecution(request);
        return this.executeListStreamSessions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStreamSessionsResult executeListStreamSessions(ListStreamSessionsRequest listStreamSessionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStreamSessionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStreamSessionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStreamSessionsRequestProtocolMarshaller(protocolFactory).marshall((ListStreamSessionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStreamSessionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStreamSessions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamSessionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStreamSessionsResult listStreamSessionsResult = (ListStreamSessionsResult)response.getAwsResponse();
            return listStreamSessionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamsResult listStreams(ListStreamsRequest request) {
        request = (ListStreamsRequest)this.beforeClientExecution(request);
        return this.executeListStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStreamsResult executeListStreams(ListStreamsRequest listStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStreamsRequestProtocolMarshaller(protocolFactory).marshall((ListStreamsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStreams");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStreamsResult listStreamsResult = (ListStreamsResult)response.getAwsResponse();
            return listStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutMetadataResult putMetadata(PutMetadataRequest request) {
        request = (PutMetadataRequest)this.beforeClientExecution(request);
        return this.executePutMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutMetadataResult executePutMetadata(PutMetadataRequest putMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutMetadataRequestProtocolMarshaller(protocolFactory).marshall((PutMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)putMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutMetadataResult putMetadataResult = (PutMetadataResult)response.getAwsResponse();
            return putMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartViewerSessionRevocationResult startViewerSessionRevocation(StartViewerSessionRevocationRequest request) {
        request = (StartViewerSessionRevocationRequest)this.beforeClientExecution(request);
        return this.executeStartViewerSessionRevocation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartViewerSessionRevocationResult executeStartViewerSessionRevocation(StartViewerSessionRevocationRequest startViewerSessionRevocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startViewerSessionRevocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartViewerSessionRevocationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartViewerSessionRevocationRequestProtocolMarshaller(protocolFactory).marshall((StartViewerSessionRevocationRequest)super.beforeMarshalling((AmazonWebServiceRequest)startViewerSessionRevocationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartViewerSessionRevocation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartViewerSessionRevocationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartViewerSessionRevocationResult startViewerSessionRevocationResult = (StartViewerSessionRevocationResult)response.getAwsResponse();
            return startViewerSessionRevocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopStreamResult stopStream(StopStreamRequest request) {
        request = (StopStreamRequest)this.beforeClientExecution(request);
        return this.executeStopStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopStreamResult executeStopStream(StopStreamRequest stopStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopStreamRequestProtocolMarshaller(protocolFactory).marshall((StopStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopStreamResult stopStreamResult = (StopStreamResult)response.getAwsResponse();
            return stopStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

