/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ivs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ivs.model.StreamSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStreamsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<StreamSummary> streams;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStreamsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<StreamSummary> getStreams() {
        return this.streams;
    }

    public void setStreams(Collection<StreamSummary> streams) {
        if (streams == null) {
            this.streams = null;
            return;
        }
        this.streams = new ArrayList<StreamSummary>(streams);
    }

    public ListStreamsResult withStreams(StreamSummary ... streams) {
        if (this.streams == null) {
            this.setStreams(new ArrayList<StreamSummary>(streams.length));
        }
        for (StreamSummary ele : streams) {
            this.streams.add(ele);
        }
        return this;
    }

    public ListStreamsResult withStreams(Collection<StreamSummary> streams) {
        this.setStreams(streams);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getStreams() != null) {
            sb.append("Streams: ").append(this.getStreams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResult)) {
            return false;
        }
        ListStreamsResult other = (ListStreamsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getStreams() == null ^ this.getStreams() == null) {
            return false;
        }
        return other.getStreams() == null || other.getStreams().equals(this.getStreams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getStreams() == null ? 0 : this.getStreams().hashCode());
        return hashCode;
    }

    public ListStreamsResult clone() {
        try {
            return (ListStreamsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

