/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.AggregationPeriod;
import com.amazonaws.services.iotwireless.model.Dimension;
import com.amazonaws.services.iotwireless.model.MetricName;
import com.amazonaws.services.iotwireless.model.MetricQueryStatus;
import com.amazonaws.services.iotwireless.model.MetricQueryValue;
import com.amazonaws.services.iotwireless.model.transform.SummaryMetricQueryResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SummaryMetricQueryResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String queryId;
    private String queryStatus;
    private String error;
    private String metricName;
    private List<Dimension> dimensions;
    private String aggregationPeriod;
    private Date startTimestamp;
    private Date endTimestamp;
    private List<Date> timestamps;
    private List<MetricQueryValue> values;
    private String unit;

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public SummaryMetricQueryResult withQueryId(String queryId) {
        this.setQueryId(queryId);
        return this;
    }

    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    public String getQueryStatus() {
        return this.queryStatus;
    }

    public SummaryMetricQueryResult withQueryStatus(String queryStatus) {
        this.setQueryStatus(queryStatus);
        return this;
    }

    public SummaryMetricQueryResult withQueryStatus(MetricQueryStatus queryStatus) {
        this.queryStatus = queryStatus.toString();
        return this;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public SummaryMetricQueryResult withError(String error) {
        this.setError(error);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public SummaryMetricQueryResult withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public SummaryMetricQueryResult withMetricName(MetricName metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<Dimension>(dimensions);
    }

    public SummaryMetricQueryResult withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public SummaryMetricQueryResult withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setAggregationPeriod(String aggregationPeriod) {
        this.aggregationPeriod = aggregationPeriod;
    }

    public String getAggregationPeriod() {
        return this.aggregationPeriod;
    }

    public SummaryMetricQueryResult withAggregationPeriod(String aggregationPeriod) {
        this.setAggregationPeriod(aggregationPeriod);
        return this;
    }

    public SummaryMetricQueryResult withAggregationPeriod(AggregationPeriod aggregationPeriod) {
        this.aggregationPeriod = aggregationPeriod.toString();
        return this;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public SummaryMetricQueryResult withStartTimestamp(Date startTimestamp) {
        this.setStartTimestamp(startTimestamp);
        return this;
    }

    public void setEndTimestamp(Date endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public SummaryMetricQueryResult withEndTimestamp(Date endTimestamp) {
        this.setEndTimestamp(endTimestamp);
        return this;
    }

    public List<Date> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(Collection<Date> timestamps) {
        if (timestamps == null) {
            this.timestamps = null;
            return;
        }
        this.timestamps = new ArrayList<Date>(timestamps);
    }

    public SummaryMetricQueryResult withTimestamps(Date ... timestamps) {
        if (this.timestamps == null) {
            this.setTimestamps(new ArrayList<Date>(timestamps.length));
        }
        for (Date ele : timestamps) {
            this.timestamps.add(ele);
        }
        return this;
    }

    public SummaryMetricQueryResult withTimestamps(Collection<Date> timestamps) {
        this.setTimestamps(timestamps);
        return this;
    }

    public List<MetricQueryValue> getValues() {
        return this.values;
    }

    public void setValues(Collection<MetricQueryValue> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<MetricQueryValue>(values);
    }

    public SummaryMetricQueryResult withValues(MetricQueryValue ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<MetricQueryValue>(values.length));
        }
        for (MetricQueryValue ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public SummaryMetricQueryResult withValues(Collection<MetricQueryValue> values) {
        this.setValues(values);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public SummaryMetricQueryResult withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryId() != null) {
            sb.append("QueryId: ").append(this.getQueryId()).append(",");
        }
        if (this.getQueryStatus() != null) {
            sb.append("QueryStatus: ").append(this.getQueryStatus()).append(",");
        }
        if (this.getError() != null) {
            sb.append("Error: ").append(this.getError()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getAggregationPeriod() != null) {
            sb.append("AggregationPeriod: ").append(this.getAggregationPeriod()).append(",");
        }
        if (this.getStartTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.getStartTimestamp()).append(",");
        }
        if (this.getEndTimestamp() != null) {
            sb.append("EndTimestamp: ").append(this.getEndTimestamp()).append(",");
        }
        if (this.getTimestamps() != null) {
            sb.append("Timestamps: ").append(this.getTimestamps()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummaryMetricQueryResult)) {
            return false;
        }
        SummaryMetricQueryResult other = (SummaryMetricQueryResult)obj;
        if (other.getQueryId() == null ^ this.getQueryId() == null) {
            return false;
        }
        if (other.getQueryId() != null && !other.getQueryId().equals(this.getQueryId())) {
            return false;
        }
        if (other.getQueryStatus() == null ^ this.getQueryStatus() == null) {
            return false;
        }
        if (other.getQueryStatus() != null && !other.getQueryStatus().equals(this.getQueryStatus())) {
            return false;
        }
        if (other.getError() == null ^ this.getError() == null) {
            return false;
        }
        if (other.getError() != null && !other.getError().equals(this.getError())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getAggregationPeriod() == null ^ this.getAggregationPeriod() == null) {
            return false;
        }
        if (other.getAggregationPeriod() != null && !other.getAggregationPeriod().equals(this.getAggregationPeriod())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        if (other.getStartTimestamp() != null && !other.getStartTimestamp().equals(this.getStartTimestamp())) {
            return false;
        }
        if (other.getEndTimestamp() == null ^ this.getEndTimestamp() == null) {
            return false;
        }
        if (other.getEndTimestamp() != null && !other.getEndTimestamp().equals(this.getEndTimestamp())) {
            return false;
        }
        if (other.getTimestamps() == null ^ this.getTimestamps() == null) {
            return false;
        }
        if (other.getTimestamps() != null && !other.getTimestamps().equals(this.getTimestamps())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryId() == null ? 0 : this.getQueryId().hashCode());
        hashCode = 31 * hashCode + (this.getQueryStatus() == null ? 0 : this.getQueryStatus().hashCode());
        hashCode = 31 * hashCode + (this.getError() == null ? 0 : this.getError().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationPeriod() == null ? 0 : this.getAggregationPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEndTimestamp() == null ? 0 : this.getEndTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamps() == null ? 0 : this.getTimestamps().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public SummaryMetricQueryResult clone() {
        try {
            return (SummaryMetricQueryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummaryMetricQueryResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

