/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iottwinmaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that contains information about a workspace.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/WorkspaceSummary" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class WorkspaceSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     */
    private String workspaceId;
    /**
     * <p>
     * The ARN of the workspace.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The description of the workspace.
     * </p>
     */
    private String description;
    /**
     * <p>
     * A list of services that are linked to the workspace.
     * </p>
     */
    private java.util.List<String> linkedServices;
    /**
     * <p>
     * The date and time when the workspace was created.
     * </p>
     */
    private java.util.Date creationDateTime;
    /**
     * <p>
     * The date and time when the workspace was last updated.
     * </p>
     */
    private java.util.Date updateDateTime;

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @param workspaceId
     *        The ID of the workspace.
     */

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @return The ID of the workspace.
     */

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @param workspaceId
     *        The ID of the workspace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withWorkspaceId(String workspaceId) {
        setWorkspaceId(workspaceId);
        return this;
    }

    /**
     * <p>
     * The ARN of the workspace.
     * </p>
     * 
     * @param arn
     *        The ARN of the workspace.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN of the workspace.
     * </p>
     * 
     * @return The ARN of the workspace.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN of the workspace.
     * </p>
     * 
     * @param arn
     *        The ARN of the workspace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The description of the workspace.
     * </p>
     * 
     * @param description
     *        The description of the workspace.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the workspace.
     * </p>
     * 
     * @return The description of the workspace.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the workspace.
     * </p>
     * 
     * @param description
     *        The description of the workspace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * A list of services that are linked to the workspace.
     * </p>
     * 
     * @return A list of services that are linked to the workspace.
     */

    public java.util.List<String> getLinkedServices() {
        return linkedServices;
    }

    /**
     * <p>
     * A list of services that are linked to the workspace.
     * </p>
     * 
     * @param linkedServices
     *        A list of services that are linked to the workspace.
     */

    public void setLinkedServices(java.util.Collection<String> linkedServices) {
        if (linkedServices == null) {
            this.linkedServices = null;
            return;
        }

        this.linkedServices = new java.util.ArrayList<String>(linkedServices);
    }

    /**
     * <p>
     * A list of services that are linked to the workspace.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLinkedServices(java.util.Collection)} or {@link #withLinkedServices(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param linkedServices
     *        A list of services that are linked to the workspace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withLinkedServices(String... linkedServices) {
        if (this.linkedServices == null) {
            setLinkedServices(new java.util.ArrayList<String>(linkedServices.length));
        }
        for (String ele : linkedServices) {
            this.linkedServices.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of services that are linked to the workspace.
     * </p>
     * 
     * @param linkedServices
     *        A list of services that are linked to the workspace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withLinkedServices(java.util.Collection<String> linkedServices) {
        setLinkedServices(linkedServices);
        return this;
    }

    /**
     * <p>
     * The date and time when the workspace was created.
     * </p>
     * 
     * @param creationDateTime
     *        The date and time when the workspace was created.
     */

    public void setCreationDateTime(java.util.Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    /**
     * <p>
     * The date and time when the workspace was created.
     * </p>
     * 
     * @return The date and time when the workspace was created.
     */

    public java.util.Date getCreationDateTime() {
        return this.creationDateTime;
    }

    /**
     * <p>
     * The date and time when the workspace was created.
     * </p>
     * 
     * @param creationDateTime
     *        The date and time when the workspace was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withCreationDateTime(java.util.Date creationDateTime) {
        setCreationDateTime(creationDateTime);
        return this;
    }

    /**
     * <p>
     * The date and time when the workspace was last updated.
     * </p>
     * 
     * @param updateDateTime
     *        The date and time when the workspace was last updated.
     */

    public void setUpdateDateTime(java.util.Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    /**
     * <p>
     * The date and time when the workspace was last updated.
     * </p>
     * 
     * @return The date and time when the workspace was last updated.
     */

    public java.util.Date getUpdateDateTime() {
        return this.updateDateTime;
    }

    /**
     * <p>
     * The date and time when the workspace was last updated.
     * </p>
     * 
     * @param updateDateTime
     *        The date and time when the workspace was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSummary withUpdateDateTime(java.util.Date updateDateTime) {
        setUpdateDateTime(updateDateTime);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWorkspaceId() != null)
            sb.append("WorkspaceId: ").append(getWorkspaceId()).append(",");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getLinkedServices() != null)
            sb.append("LinkedServices: ").append(getLinkedServices()).append(",");
        if (getCreationDateTime() != null)
            sb.append("CreationDateTime: ").append(getCreationDateTime()).append(",");
        if (getUpdateDateTime() != null)
            sb.append("UpdateDateTime: ").append(getUpdateDateTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof WorkspaceSummary == false)
            return false;
        WorkspaceSummary other = (WorkspaceSummary) obj;
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null)
            return false;
        if (other.getWorkspaceId() != null && other.getWorkspaceId().equals(this.getWorkspaceId()) == false)
            return false;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getLinkedServices() == null ^ this.getLinkedServices() == null)
            return false;
        if (other.getLinkedServices() != null && other.getLinkedServices().equals(this.getLinkedServices()) == false)
            return false;
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null)
            return false;
        if (other.getCreationDateTime() != null && other.getCreationDateTime().equals(this.getCreationDateTime()) == false)
            return false;
        if (other.getUpdateDateTime() == null ^ this.getUpdateDateTime() == null)
            return false;
        if (other.getUpdateDateTime() != null && other.getUpdateDateTime().equals(this.getUpdateDateTime()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWorkspaceId() == null) ? 0 : getWorkspaceId().hashCode());
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getLinkedServices() == null) ? 0 : getLinkedServices().hashCode());
        hashCode = prime * hashCode + ((getCreationDateTime() == null) ? 0 : getCreationDateTime().hashCode());
        hashCode = prime * hashCode + ((getUpdateDateTime() == null) ? 0 : getUpdateDateTime().hashCode());
        return hashCode;
    }

    @Override
    public WorkspaceSummary clone() {
        try {
            return (WorkspaceSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iottwinmaker.model.transform.WorkspaceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
