/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iottwinmaker.AWSIoTTwinMaker;
import com.amazonaws.services.iottwinmaker.AWSIoTTwinMakerClientBuilder;
import com.amazonaws.services.iottwinmaker.model.AWSIoTTwinMakerException;
import com.amazonaws.services.iottwinmaker.model.BatchPutPropertyValuesRequest;
import com.amazonaws.services.iottwinmaker.model.BatchPutPropertyValuesResult;
import com.amazonaws.services.iottwinmaker.model.CreateComponentTypeRequest;
import com.amazonaws.services.iottwinmaker.model.CreateComponentTypeResult;
import com.amazonaws.services.iottwinmaker.model.CreateEntityRequest;
import com.amazonaws.services.iottwinmaker.model.CreateEntityResult;
import com.amazonaws.services.iottwinmaker.model.CreateSceneRequest;
import com.amazonaws.services.iottwinmaker.model.CreateSceneResult;
import com.amazonaws.services.iottwinmaker.model.CreateWorkspaceRequest;
import com.amazonaws.services.iottwinmaker.model.CreateWorkspaceResult;
import com.amazonaws.services.iottwinmaker.model.DeleteComponentTypeRequest;
import com.amazonaws.services.iottwinmaker.model.DeleteComponentTypeResult;
import com.amazonaws.services.iottwinmaker.model.DeleteEntityRequest;
import com.amazonaws.services.iottwinmaker.model.DeleteEntityResult;
import com.amazonaws.services.iottwinmaker.model.DeleteSceneRequest;
import com.amazonaws.services.iottwinmaker.model.DeleteSceneResult;
import com.amazonaws.services.iottwinmaker.model.DeleteWorkspaceRequest;
import com.amazonaws.services.iottwinmaker.model.DeleteWorkspaceResult;
import com.amazonaws.services.iottwinmaker.model.GetComponentTypeRequest;
import com.amazonaws.services.iottwinmaker.model.GetComponentTypeResult;
import com.amazonaws.services.iottwinmaker.model.GetEntityRequest;
import com.amazonaws.services.iottwinmaker.model.GetEntityResult;
import com.amazonaws.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import com.amazonaws.services.iottwinmaker.model.GetPropertyValueHistoryResult;
import com.amazonaws.services.iottwinmaker.model.GetPropertyValueRequest;
import com.amazonaws.services.iottwinmaker.model.GetPropertyValueResult;
import com.amazonaws.services.iottwinmaker.model.GetSceneRequest;
import com.amazonaws.services.iottwinmaker.model.GetSceneResult;
import com.amazonaws.services.iottwinmaker.model.GetWorkspaceRequest;
import com.amazonaws.services.iottwinmaker.model.GetWorkspaceResult;
import com.amazonaws.services.iottwinmaker.model.ListComponentTypesRequest;
import com.amazonaws.services.iottwinmaker.model.ListComponentTypesResult;
import com.amazonaws.services.iottwinmaker.model.ListEntitiesRequest;
import com.amazonaws.services.iottwinmaker.model.ListEntitiesResult;
import com.amazonaws.services.iottwinmaker.model.ListScenesRequest;
import com.amazonaws.services.iottwinmaker.model.ListScenesResult;
import com.amazonaws.services.iottwinmaker.model.ListTagsForResourceRequest;
import com.amazonaws.services.iottwinmaker.model.ListTagsForResourceResult;
import com.amazonaws.services.iottwinmaker.model.ListWorkspacesRequest;
import com.amazonaws.services.iottwinmaker.model.ListWorkspacesResult;
import com.amazonaws.services.iottwinmaker.model.TagResourceRequest;
import com.amazonaws.services.iottwinmaker.model.TagResourceResult;
import com.amazonaws.services.iottwinmaker.model.UntagResourceRequest;
import com.amazonaws.services.iottwinmaker.model.UntagResourceResult;
import com.amazonaws.services.iottwinmaker.model.UpdateComponentTypeRequest;
import com.amazonaws.services.iottwinmaker.model.UpdateComponentTypeResult;
import com.amazonaws.services.iottwinmaker.model.UpdateEntityRequest;
import com.amazonaws.services.iottwinmaker.model.UpdateEntityResult;
import com.amazonaws.services.iottwinmaker.model.UpdateSceneRequest;
import com.amazonaws.services.iottwinmaker.model.UpdateSceneResult;
import com.amazonaws.services.iottwinmaker.model.UpdateWorkspaceRequest;
import com.amazonaws.services.iottwinmaker.model.UpdateWorkspaceResult;
import com.amazonaws.services.iottwinmaker.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.BatchPutPropertyValuesRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.BatchPutPropertyValuesResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ConnectorFailureExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ConnectorTimeoutExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateComponentTypeRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateComponentTypeResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateEntityRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateEntityResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateSceneRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateSceneResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.CreateWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteComponentTypeRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteComponentTypeResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteEntityRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteEntityResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteSceneRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteSceneResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.DeleteWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetComponentTypeRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetComponentTypeResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetEntityRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetEntityResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetPropertyValueHistoryRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetPropertyValueHistoryResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetPropertyValueRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetPropertyValueResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetSceneRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetSceneResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.GetWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListComponentTypesRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListComponentTypesResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListScenesRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListScenesResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListWorkspacesRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ListWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateComponentTypeRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateComponentTypeResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateEntityRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateEntityResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateSceneRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateSceneResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateWorkspaceRequestProtocolMarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.UpdateWorkspaceResultJsonUnmarshaller;
import com.amazonaws.services.iottwinmaker.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSIoTTwinMakerClient
extends AmazonWebServiceClient
implements AWSIoTTwinMaker {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSIoTTwinMaker.class);
    private static final String DEFAULT_SIGNING_NAME = "iottwinmaker";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConnectorFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConnectorFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConnectorTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConnectorTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSIoTTwinMakerException.class));

    public static AWSIoTTwinMakerClientBuilder builder() {
        return AWSIoTTwinMakerClientBuilder.standard();
    }

    AWSIoTTwinMakerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSIoTTwinMakerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("iottwinmaker.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/iottwinmaker/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/iottwinmaker/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchPutPropertyValuesResult batchPutPropertyValues(BatchPutPropertyValuesRequest request) {
        request = (BatchPutPropertyValuesRequest)this.beforeClientExecution(request);
        return this.executeBatchPutPropertyValues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchPutPropertyValuesResult executeBatchPutPropertyValues(BatchPutPropertyValuesRequest batchPutPropertyValuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutPropertyValuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutPropertyValuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutPropertyValuesRequestProtocolMarshaller(protocolFactory).marshall((BatchPutPropertyValuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchPutPropertyValuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchPutPropertyValues");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "data.";
                String resolvedHostPrefix = String.format("data.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchPutPropertyValuesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            BatchPutPropertyValuesResult batchPutPropertyValuesResult = (BatchPutPropertyValuesResult)response.getAwsResponse();
            return batchPutPropertyValuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateComponentTypeResult createComponentType(CreateComponentTypeRequest request) {
        request = (CreateComponentTypeRequest)this.beforeClientExecution(request);
        return this.executeCreateComponentType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateComponentTypeResult executeCreateComponentType(CreateComponentTypeRequest createComponentTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createComponentTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateComponentTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateComponentTypeRequestProtocolMarshaller(protocolFactory).marshall((CreateComponentTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createComponentTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateComponentType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateComponentTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateComponentTypeResult createComponentTypeResult = (CreateComponentTypeResult)response.getAwsResponse();
            return createComponentTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEntityResult createEntity(CreateEntityRequest request) {
        request = (CreateEntityRequest)this.beforeClientExecution(request);
        return this.executeCreateEntity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEntityResult executeCreateEntity(CreateEntityRequest createEntityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEntityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEntityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEntityRequestProtocolMarshaller(protocolFactory).marshall((CreateEntityRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEntityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEntity");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEntityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateEntityResult createEntityResult = (CreateEntityResult)response.getAwsResponse();
            return createEntityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSceneResult createScene(CreateSceneRequest request) {
        request = (CreateSceneRequest)this.beforeClientExecution(request);
        return this.executeCreateScene(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSceneResult executeCreateScene(CreateSceneRequest createSceneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSceneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSceneRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSceneRequestProtocolMarshaller(protocolFactory).marshall((CreateSceneRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSceneRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateScene");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSceneResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateSceneResult createSceneResult = (CreateSceneResult)response.getAwsResponse();
            return createSceneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateWorkspaceResult createWorkspace(CreateWorkspaceRequest request) {
        request = (CreateWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeCreateWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateWorkspaceResult executeCreateWorkspace(CreateWorkspaceRequest createWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((CreateWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            CreateWorkspaceResult createWorkspaceResult = (CreateWorkspaceResult)response.getAwsResponse();
            return createWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteComponentTypeResult deleteComponentType(DeleteComponentTypeRequest request) {
        request = (DeleteComponentTypeRequest)this.beforeClientExecution(request);
        return this.executeDeleteComponentType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteComponentTypeResult executeDeleteComponentType(DeleteComponentTypeRequest deleteComponentTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteComponentTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteComponentTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteComponentTypeRequestProtocolMarshaller(protocolFactory).marshall((DeleteComponentTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteComponentTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteComponentType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteComponentTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteComponentTypeResult deleteComponentTypeResult = (DeleteComponentTypeResult)response.getAwsResponse();
            return deleteComponentTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEntityResult deleteEntity(DeleteEntityRequest request) {
        request = (DeleteEntityRequest)this.beforeClientExecution(request);
        return this.executeDeleteEntity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEntityResult executeDeleteEntity(DeleteEntityRequest deleteEntityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEntityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEntityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEntityRequestProtocolMarshaller(protocolFactory).marshall((DeleteEntityRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEntityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEntity");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEntityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteEntityResult deleteEntityResult = (DeleteEntityResult)response.getAwsResponse();
            return deleteEntityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSceneResult deleteScene(DeleteSceneRequest request) {
        request = (DeleteSceneRequest)this.beforeClientExecution(request);
        return this.executeDeleteScene(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSceneResult executeDeleteScene(DeleteSceneRequest deleteSceneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSceneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSceneRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSceneRequestProtocolMarshaller(protocolFactory).marshall((DeleteSceneRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSceneRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteScene");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSceneResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteSceneResult deleteSceneResult = (DeleteSceneResult)response.getAwsResponse();
            return deleteSceneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteWorkspaceResult deleteWorkspace(DeleteWorkspaceRequest request) {
        request = (DeleteWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeDeleteWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteWorkspaceResult executeDeleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((DeleteWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            DeleteWorkspaceResult deleteWorkspaceResult = (DeleteWorkspaceResult)response.getAwsResponse();
            return deleteWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComponentTypeResult getComponentType(GetComponentTypeRequest request) {
        request = (GetComponentTypeRequest)this.beforeClientExecution(request);
        return this.executeGetComponentType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetComponentTypeResult executeGetComponentType(GetComponentTypeRequest getComponentTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComponentTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComponentTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComponentTypeRequestProtocolMarshaller(protocolFactory).marshall((GetComponentTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComponentTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetComponentType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComponentTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetComponentTypeResult getComponentTypeResult = (GetComponentTypeResult)response.getAwsResponse();
            return getComponentTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEntityResult getEntity(GetEntityRequest request) {
        request = (GetEntityRequest)this.beforeClientExecution(request);
        return this.executeGetEntity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEntityResult executeGetEntity(GetEntityRequest getEntityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEntityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEntityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEntityRequestProtocolMarshaller(protocolFactory).marshall((GetEntityRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEntityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEntity");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEntityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetEntityResult getEntityResult = (GetEntityResult)response.getAwsResponse();
            return getEntityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPropertyValueResult getPropertyValue(GetPropertyValueRequest request) {
        request = (GetPropertyValueRequest)this.beforeClientExecution(request);
        return this.executeGetPropertyValue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPropertyValueResult executeGetPropertyValue(GetPropertyValueRequest getPropertyValueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPropertyValueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPropertyValueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPropertyValueRequestProtocolMarshaller(protocolFactory).marshall((GetPropertyValueRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPropertyValueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPropertyValue");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "data.";
                String resolvedHostPrefix = String.format("data.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPropertyValueResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetPropertyValueResult getPropertyValueResult = (GetPropertyValueResult)response.getAwsResponse();
            return getPropertyValueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPropertyValueHistoryResult getPropertyValueHistory(GetPropertyValueHistoryRequest request) {
        request = (GetPropertyValueHistoryRequest)this.beforeClientExecution(request);
        return this.executeGetPropertyValueHistory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPropertyValueHistoryResult executeGetPropertyValueHistory(GetPropertyValueHistoryRequest getPropertyValueHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPropertyValueHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPropertyValueHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPropertyValueHistoryRequestProtocolMarshaller(protocolFactory).marshall((GetPropertyValueHistoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPropertyValueHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPropertyValueHistory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "data.";
                String resolvedHostPrefix = String.format("data.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPropertyValueHistoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetPropertyValueHistoryResult getPropertyValueHistoryResult = (GetPropertyValueHistoryResult)response.getAwsResponse();
            return getPropertyValueHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSceneResult getScene(GetSceneRequest request) {
        request = (GetSceneRequest)this.beforeClientExecution(request);
        return this.executeGetScene(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSceneResult executeGetScene(GetSceneRequest getSceneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSceneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSceneRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSceneRequestProtocolMarshaller(protocolFactory).marshall((GetSceneRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSceneRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetScene");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSceneResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetSceneResult getSceneResult = (GetSceneResult)response.getAwsResponse();
            return getSceneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetWorkspaceResult getWorkspace(GetWorkspaceRequest request) {
        request = (GetWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeGetWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetWorkspaceResult executeGetWorkspace(GetWorkspaceRequest getWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((GetWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            GetWorkspaceResult getWorkspaceResult = (GetWorkspaceResult)response.getAwsResponse();
            return getWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListComponentTypesResult listComponentTypes(ListComponentTypesRequest request) {
        request = (ListComponentTypesRequest)this.beforeClientExecution(request);
        return this.executeListComponentTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListComponentTypesResult executeListComponentTypes(ListComponentTypesRequest listComponentTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listComponentTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListComponentTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListComponentTypesRequestProtocolMarshaller(protocolFactory).marshall((ListComponentTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listComponentTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListComponentTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListComponentTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListComponentTypesResult listComponentTypesResult = (ListComponentTypesResult)response.getAwsResponse();
            return listComponentTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEntitiesResult listEntities(ListEntitiesRequest request) {
        request = (ListEntitiesRequest)this.beforeClientExecution(request);
        return this.executeListEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEntitiesResult executeListEntities(ListEntitiesRequest listEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEntitiesRequestProtocolMarshaller(protocolFactory).marshall((ListEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListEntitiesResult listEntitiesResult = (ListEntitiesResult)response.getAwsResponse();
            return listEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListScenesResult listScenes(ListScenesRequest request) {
        request = (ListScenesRequest)this.beforeClientExecution(request);
        return this.executeListScenes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListScenesResult executeListScenes(ListScenesRequest listScenesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listScenesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListScenesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListScenesRequestProtocolMarshaller(protocolFactory).marshall((ListScenesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listScenesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListScenes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListScenesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListScenesResult listScenesResult = (ListScenesResult)response.getAwsResponse();
            return listScenesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListWorkspacesResult listWorkspaces(ListWorkspacesRequest request) {
        request = (ListWorkspacesRequest)this.beforeClientExecution(request);
        return this.executeListWorkspaces(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListWorkspacesResult executeListWorkspaces(ListWorkspacesRequest listWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkspacesRequestProtocolMarshaller(protocolFactory).marshall((ListWorkspacesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkspaces");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListWorkspacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            ListWorkspacesResult listWorkspacesResult = (ListWorkspacesResult)response.getAwsResponse();
            return listWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateComponentTypeResult updateComponentType(UpdateComponentTypeRequest request) {
        request = (UpdateComponentTypeRequest)this.beforeClientExecution(request);
        return this.executeUpdateComponentType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateComponentTypeResult executeUpdateComponentType(UpdateComponentTypeRequest updateComponentTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateComponentTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateComponentTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateComponentTypeRequestProtocolMarshaller(protocolFactory).marshall((UpdateComponentTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateComponentTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateComponentType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateComponentTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateComponentTypeResult updateComponentTypeResult = (UpdateComponentTypeResult)response.getAwsResponse();
            return updateComponentTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEntityResult updateEntity(UpdateEntityRequest request) {
        request = (UpdateEntityRequest)this.beforeClientExecution(request);
        return this.executeUpdateEntity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEntityResult executeUpdateEntity(UpdateEntityRequest updateEntityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEntityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEntityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEntityRequestProtocolMarshaller(protocolFactory).marshall((UpdateEntityRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEntityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEntity");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEntityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateEntityResult updateEntityResult = (UpdateEntityResult)response.getAwsResponse();
            return updateEntityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSceneResult updateScene(UpdateSceneRequest request) {
        request = (UpdateSceneRequest)this.beforeClientExecution(request);
        return this.executeUpdateScene(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSceneResult executeUpdateScene(UpdateSceneRequest updateSceneRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSceneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSceneRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSceneRequestProtocolMarshaller(protocolFactory).marshall((UpdateSceneRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSceneRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateScene");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSceneResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateSceneResult updateSceneResult = (UpdateSceneResult)response.getAwsResponse();
            return updateSceneResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateWorkspaceResult updateWorkspace(UpdateWorkspaceRequest request) {
        request = (UpdateWorkspaceRequest)this.beforeClientExecution(request);
        return this.executeUpdateWorkspace(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateWorkspaceResult executeUpdateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateWorkspaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateWorkspaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateWorkspaceRequestProtocolMarshaller(protocolFactory).marshall((UpdateWorkspaceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateWorkspaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"IoTTwinMaker");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateWorkspace");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            URI endpointTraitHost = null;
            if (!this.clientConfiguration.isDisableHostPrefixInjection()) {
                String hostPrefix = "api.";
                String resolvedHostPrefix = String.format("api.", new Object[0]);
                endpointTraitHost = UriResourcePathUtils.updateUriHost((URI)this.endpoint, (String)resolvedHostPrefix);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateWorkspaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext, null, endpointTraitHost);
            UpdateWorkspaceResult updateWorkspaceResult = (UpdateWorkspaceResult)response.getAwsResponse();
            return updateWorkspaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

